/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.AbstractInteractivePlugin;
import qupath.lib.plugins.parameters.Parameter;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.roi.interfaces.ROI;

public class SmoothFeaturesPlugin<T>
extends AbstractInteractivePlugin<T> {
    private ParameterList params = new ParameterList().addDoubleParameter("fwhmMicrons", "Radius (FWHM)", 25.0, GeneralTools.micrometerSymbol(), "Smoothing filter size - higher values indicate more smoothing").addDoubleParameter("fwhmPixels", "Radius (FWHM)", 100.0, "pixels", "Smoothing filter size - higher values indicate more smoothing").addBooleanParameter("smoothWithinClasses", "Smooth within classes", false, "Restrict smoothing to only be applied within objects with the same base classification");
    private static final Logger logger = LoggerFactory.getLogger(SmoothFeaturesPlugin.class);

    public String getName() {
        return "Smooth object features";
    }

    public String getDescription() {
        return "Apply weighted smoothing to feature measurements, and append to the end of a list";
    }

    public String getLastResultsDescription() {
        return "";
    }

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        ArrayList<Class<? extends PathObject>> parentClasses = new ArrayList<Class<? extends PathObject>>();
        parentClasses.add(TMACoreObject.class);
        parentClasses.add(PathAnnotationObject.class);
        return parentClasses;
    }

    protected void addRunnableTasks(ImageData<T> imageData, final PathObject parentObject, List<Runnable> tasks) {
        String fwhmStringTemp;
        double fwhm;
        PixelCalibration cal;
        ImageServer server = imageData.getServer();
        PixelCalibration pixelCalibration = cal = server == null ? null : server.getPixelCalibration();
        if (cal != null && cal.hasPixelSizeMicrons()) {
            fwhm = this.getParameterList(imageData).getDoubleParameterValue("fwhmMicrons");
            fwhmStringTemp = GeneralTools.createFormatter((int)2).format(fwhm) + " " + GeneralTools.micrometerSymbol();
            fwhm /= cal.getAveragedPixelSizeMicrons();
        } else {
            fwhm = this.getParameterList(imageData).getDoubleParameterValue("fwhmPixels");
            fwhmStringTemp = GeneralTools.createFormatter((int)2).format(fwhm) + " px";
        }
        final String fwhmString = fwhmStringTemp;
        final double fwhmPixels = fwhm;
        final boolean withinClass = this.params.getBooleanParameterValue("smoothWithinClasses");
        final boolean useLegacyNames = this.params.containsKey((Object)"useLegacyNames") && Boolean.TRUE.equals(this.params.getBooleanParameterValue("useLegacyNames"));
        tasks.add(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!parentObject.hasChildObjects()) {
                        return;
                    }
                    List pathObjects = PathObjectTools.getFlattenedObjectList((PathObject)parentObject, null, (boolean)false);
                    Iterator iterObjects = pathObjects.iterator();
                    while (iterObjects.hasNext()) {
                        PathObject temp = (PathObject)iterObjects.next();
                        if (temp instanceof PathDetectionObject || temp instanceof PathTileObject) continue;
                        iterObjects.remove();
                    }
                    if (pathObjects.isEmpty()) {
                        return;
                    }
                    ArrayList<String> measurements = new ArrayList<String>(PathObjectTools.getAvailableFeatures((Collection)pathObjects));
                    Iterator iter = measurements.iterator();
                    while (iter.hasNext()) {
                        String name = ((String)iter.next()).toLowerCase();
                        if (!name.endsWith("smoothed") && !name.startsWith("smoothed") && !name.contains(" - smoothed (fwhm ") && !name.startsWith("smoothed denominator (local density, ") && !name.startsWith("nearby detection counts")) continue;
                        iter.remove();
                    }
                    logger.debug(String.format("Smooth features: %s (FWHM: %.2f px)", parentObject.getDisplayedName(), fwhmPixels));
                    SmoothFeaturesPlugin.smoothMeasurements(pathObjects, measurements, fwhmPixels, fwhmString, withinClass, useLegacyNames);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
        });
    }

    public static void smoothMeasurements(List<PathObject> pathObjects, List<String> measurements, double fwhmPixels, String fwhmString, boolean withinClass, boolean useLegacyNames) {
        Object countsName;
        String denomName;
        String postfix;
        String prefix;
        if (measurements.isEmpty() || pathObjects.size() <= 1) {
            return;
        }
        if (fwhmString == null) {
            fwhmString = String.format("%.2f px", fwhmPixels);
        }
        double fwhmPixels2 = fwhmPixels * fwhmPixels;
        double sigmaPixels = fwhmPixels / Math.sqrt(8.0 * Math.log(2.0));
        double sigma2 = 2.0 * sigmaPixels * sigmaPixels;
        double maxDist = sigmaPixels * 3.0;
        double maxDistSq = maxDist * maxDist;
        int nObjects = pathObjects.size();
        Collections.sort(pathObjects, new Comparator<PathObject>(){

            @Override
            public int compare(PathObject o1, PathObject o2) {
                double x1 = o1.getROI().getCentroidX();
                double x2 = o2.getROI().getCentroidX();
                return Double.compare(x1, x2);
            }
        });
        double[] distanceWeights = new double[(int)(maxDist + 0.5) + 1];
        for (int i = 0; i < distanceWeights.length; ++i) {
            distanceWeights[i] = Math.exp((double)(-(i * i)) / sigma2);
        }
        System.currentTimeMillis();
        float[] xCentroids = new float[nObjects];
        float[] yCentroids = new float[nObjects];
        PathClass[] pathClasses = new PathClass[nObjects];
        int[] nearbyDetectionCounts = new int[nObjects];
        float[][] measurementsWeighted = new float[nObjects][measurements.size()];
        float[][] measurementDenominators = new float[nObjects][measurements.size()];
        float[][] measurementValues = new float[nObjects][measurements.size()];
        for (int i = 0; i < nObjects; ++i) {
            PathObject pathObject = pathObjects.get(i);
            if (withinClass) {
                pathClasses[i] = pathObject.getPathClass() == null ? null : pathObject.getPathClass().getBaseClass();
            }
            ROI roi = pathObject.getROI();
            xCentroids[i] = (float)roi.getCentroidX();
            yCentroids[i] = (float)roi.getCentroidY();
            MeasurementList measurementList = pathObject.getMeasurementList();
            int ind = 0;
            for (String name : measurements) {
                float value;
                measurementValues[i][ind] = value = (float)measurementList.get(name);
                measurementsWeighted[i][ind] = value;
                measurementDenominators[i][ind] = 1.0f;
                ++ind;
            }
        }
        if (useLegacyNames) {
            prefix = "";
            postfix = String.format(" - Smoothed (FWHM %s)", fwhmString);
            denomName = String.format("Smoothed denominator (local density, FWHM %s)", fwhmString);
            countsName = String.format("Nearby detection counts (radius %s)", fwhmString);
        } else {
            prefix = String.format("Smoothed: %s: ", fwhmString);
            postfix = "";
            denomName = null;
            countsName = prefix + "Nearby detection counts";
        }
        for (int i = 0; i < nObjects; ++i) {
            PathObject pathObject = pathObjects.get(i);
            PathClass pathClass = pathClasses[i];
            MeasurementList measurementList = pathObject.getMeasurementList();
            float[] mValues = measurementValues[i];
            float[] mWeighted = measurementsWeighted[i];
            float[] mDenominator = measurementDenominators[i];
            double xi = xCentroids[i];
            double yi = yCentroids[i];
            for (int j = i + 1; j < nObjects; ++j) {
                double xj = xCentroids[j];
                double yj = yCentroids[j];
                if (Math.abs(xj - xi) > maxDist) break;
                double distSq = (xj - xi) * (xj - xi) + (yj - yi) * (yj - yi);
                if (distSq > maxDistSq || Double.isNaN(distSq) || withinClass && pathClass != pathClasses[j]) continue;
                if (distSq < fwhmPixels2) {
                    int n = i;
                    nearbyDetectionCounts[n] = nearbyDetectionCounts[n] + 1;
                    int n2 = j;
                    nearbyDetectionCounts[n2] = nearbyDetectionCounts[n2] + 1;
                }
                double weight = distanceWeights[(int)(Math.sqrt(distSq) + 0.5)];
                float[] temp = measurementValues[j];
                float[] tempWeighted = measurementsWeighted[j];
                float[] tempDenominator = measurementDenominators[j];
                for (int ind = 0; ind < measurements.size(); ++ind) {
                    float tempVal = temp[ind];
                    if (Float.isNaN(tempVal)) continue;
                    int n = ind;
                    mWeighted[n] = (float)((double)mWeighted[n] + (double)tempVal * weight);
                    int n3 = ind;
                    mDenominator[n3] = (float)((double)mDenominator[n3] + weight);
                    float tempVal2 = mValues[ind];
                    if (Float.isNaN(tempVal2)) continue;
                    int n4 = ind;
                    tempWeighted[n4] = (float)((double)tempWeighted[n4] + (double)tempVal2 * weight);
                    int n5 = ind;
                    tempDenominator[n5] = (float)((double)tempDenominator[n5] + weight);
                }
            }
            int ind = 0;
            float maxDenominator = Float.NEGATIVE_INFINITY;
            for (String name : measurements) {
                float denominator = mDenominator[ind];
                if (denominator > maxDenominator) {
                    maxDenominator = denominator;
                }
                String nameToAdd = prefix + name + postfix;
                measurementList.put(nameToAdd, (double)(mWeighted[ind] / denominator));
                ++ind;
            }
            if (pathObject instanceof PathDetectionObject && denomName != null) {
                measurementList.put(denomName, (double)maxDenominator);
            }
            if (pathObject instanceof PathDetectionObject && countsName != null) {
                measurementList.put((String)countsName, (double)nearbyDetectionCounts[i]);
            }
            measurementList.close();
        }
        System.currentTimeMillis();
    }

    public ParameterList getDefaultParameterList(ImageData<T> imageData) {
        ImageServer server = imageData.getServer();
        boolean pixelSizeMicrons = server != null && server.getPixelCalibration().hasPixelSizeMicrons();
        ((Parameter)this.params.getParameters().get("fwhmMicrons")).setHidden(!pixelSizeMicrons);
        ((Parameter)this.params.getParameters().get("fwhmPixels")).setHidden(pixelSizeMicrons);
        return this.params;
    }

    protected Collection<PathObject> getParentObjects(ImageData<T> imageData) {
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        ArrayList<PathObject> parents = new ArrayList<PathObject>();
        if (hierarchy.getTMAGrid() != null) {
            logger.info("Smoothing using TMA cores");
            for (TMACoreObject core : hierarchy.getTMAGrid().getTMACoreList()) {
                if (!core.hasChildObjects()) continue;
                parents.add((PathObject)core);
            }
        } else {
            for (PathObject pathObject : hierarchy.getSelectionModel().getSelectedObjects()) {
                if (!pathObject.isAnnotation() || !pathObject.hasChildObjects()) continue;
                parents.add(pathObject);
            }
            if (!parents.isEmpty()) {
                logger.info("Smoothing using annotations");
            }
        }
        return parents;
    }
}

