/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.objects;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.plugins.AbstractInteractivePlugin;
import qupath.lib.plugins.parameters.Parameter;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class ShapeFeaturesPlugin<T>
extends AbstractInteractivePlugin<T> {
    private ParameterList params = new ParameterList().addTitleParameter("Measurements").addBooleanParameter("area", "Area", true, "Compute area of ROI").addBooleanParameter("perimeter", "Perimeter", false, "Compute perimeter of ROI").addBooleanParameter("circularity", "Circularity", false, "Compute circularity of ROI, between 0 (a line) and 1 (a circle)").addTitleParameter("Units").addBooleanParameter("useMicrons", "Use microns", true, "Compute measurements using " + GeneralTools.micrometerSymbol() + ", where possible");
    private static final Logger logger = LoggerFactory.getLogger(ShapeFeaturesPlugin.class);

    public String getName() {
        return "Add shape measurements";
    }

    public String getDescription() {
        return "Add shape measurements to the measurement lists for objects";
    }

    public String getLastResultsDescription() {
        return "";
    }

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        return Arrays.asList(PathCellObject.class, PathDetectionObject.class);
    }

    protected void addRunnableTasks(ImageData<T> imageData, final PathObject parentObject, List<Runnable> tasks) {
        ROI roi;
        PixelCalibration cal = imageData == null ? null : imageData.getServer().getPixelCalibration();
        boolean useMicrons = this.params.getBooleanParameterValue("useMicrons") != false && cal != null && cal.hasPixelSizeMicrons();
        final double pixelWidth = useMicrons ? cal.getPixelWidthMicrons() : 1.0;
        final double pixelHeight = useMicrons ? cal.getPixelHeightMicrons() : 1.0;
        final String unit = useMicrons ? GeneralTools.micrometerSymbol() : "px";
        final boolean doArea = this.params.getBooleanParameterValue("area");
        final boolean doPerimeter = this.params.getBooleanParameterValue("perimeter");
        final boolean doCircularity = this.params.getBooleanParameterValue("circularity");
        ROI rOI = roi = parentObject.hasROI() && parentObject.getROI().isArea() ? parentObject.getROI() : null;
        if (roi != null) {
            tasks.add(new Runnable(){

                @Override
                public void run() {
                    try {
                        MeasurementList measurementList = parentObject.getMeasurementList();
                        if (parentObject instanceof PathCellObject) {
                            ROI roi = ((PathCellObject)parentObject).getNucleusROI();
                            if (roi != null && roi.isArea()) {
                                ShapeFeaturesPlugin.addMeasurements(measurementList, roi, "Nucleus Shape: ", pixelWidth, pixelHeight, unit, doArea, doPerimeter, doCircularity);
                            }
                            if ((roi = parentObject.getROI()) != null && roi.isArea()) {
                                ShapeFeaturesPlugin.addMeasurements(measurementList, roi, "Cell Shape: ", pixelWidth, pixelHeight, unit, doArea, doPerimeter, doCircularity);
                            }
                        } else {
                            ROI roi = parentObject.getROI();
                            if (roi != null && roi.isArea()) {
                                ShapeFeaturesPlugin.addMeasurements(measurementList, roi, "ROI Shape: ", pixelWidth, pixelHeight, unit, doArea, doPerimeter, doCircularity);
                            }
                        }
                        measurementList.close();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        throw e;
                    }
                }
            });
        }
    }

    private static void addMeasurements(MeasurementList measurementList, ROI roi, String prefix, double pixelWidth, double pixelHeight, String unit, boolean doArea, boolean doPerimeter, boolean doCircularity) {
        if (doArea) {
            measurementList.put(prefix + "Area " + unit + "^2", roi.getScaledArea(pixelWidth, pixelHeight));
        }
        if (doPerimeter) {
            measurementList.put(prefix + "Perimeter " + unit, roi.getScaledLength(pixelWidth, pixelHeight));
        }
        if (doCircularity) {
            measurementList.put(prefix + "Circularity", RoiTools.getCircularity((ROI)roi));
        }
    }

    public ParameterList getDefaultParameterList(ImageData<T> imageData) {
        ImageServer server = imageData.getServer();
        boolean pixelSizeMicrons = server != null && server.getPixelCalibration().hasPixelSizeMicrons();
        ((Parameter)this.params.getParameters().get("useMicrons")).setHidden(!pixelSizeMicrons);
        return this.params;
    }

    protected Collection<? extends PathObject> getParentObjects(ImageData<T> imageData) {
        return imageData.getHierarchy().getSelectionModel().getSelectedObjects();
    }
}

