/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathROIObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.AbstractInteractivePlugin;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class RefineAnnotationsPlugin<T>
extends AbstractInteractivePlugin<T> {
    private ParameterList params = new ParameterList().addDoubleParameter("minFragmentSizeMicrons", "Minimum fragment size", 0.0, GeneralTools.micrometerSymbol() + "^2", "Area of the smallest fragment to keep (set <= 0 to keep all fragments)").addDoubleParameter("minFragmentSizePixels", "Minimum fragment size", 0.0, "px^2", "Area of the smallest fragment to keep (set <= 0 to keep all fragments)").addDoubleParameter("maxHoleSizeMicrons", "Maximum hole size", 0.0, GeneralTools.micrometerSymbol() + "^2", "Area of the largest hole to keep (set < 0 to fill all holes, or 0 to fill no holes)").addDoubleParameter("maxHoleSizePixels", "Maximum hole size", 0.0, "px^2", "Area of the largest hole to keep (set < 0 to fill all holes, or 0 to fill no holes)");
    private String resultString = null;

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        return Collections.singleton(PathAnnotationObject.class);
    }

    public String getName() {
        return "Remove fragments & holes";
    }

    public String getDescription() {
        return "Refine annotation object ROIs by removing small fragments/annotations and/or filling holes";
    }

    public String getLastResultsDescription() {
        return this.resultString;
    }

    public ParameterList getDefaultParameterList(ImageData<T> imageData) {
        boolean hasMicrons = imageData.getServer().getPixelCalibration().hasPixelSizeMicrons();
        this.params.setHiddenParameters(hasMicrons, new String[]{"minFragmentSizePixels", "maxHoleSizePixels"});
        this.params.setHiddenParameters(!hasMicrons, new String[]{"minFragmentSizeMicrons", "maxHoleSizeMicrons"});
        return this.params;
    }

    protected Collection<? extends PathObject> getParentObjects(ImageData<T> imageData) {
        return imageData.getHierarchy().getSelectionModel().getSelectedObjects().stream().filter(p -> p.isAnnotation()).toList();
    }

    protected void addRunnableTasks(ImageData<T> imageData, PathObject parentObject, List<Runnable> tasks) {
    }

    protected Collection<Runnable> getTasks(ImageData<T> imageData) {
        double maxHoleSizeTemp;
        double minFragmentSize;
        Collection<PathObject> parentObjects = this.getParentObjects(imageData);
        if (parentObjects == null || parentObjects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(1);
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        ImageServer server = imageData.getServer();
        PixelCalibration cal = server.getPixelCalibration();
        if (cal.hasPixelSizeMicrons()) {
            double pixelAreaMicrons = cal.getPixelWidthMicrons() * cal.getPixelHeightMicrons();
            minFragmentSize = this.params.getDoubleParameterValue("minFragmentSizeMicrons") / pixelAreaMicrons;
            maxHoleSizeTemp = this.params.getDoubleParameterValue("maxHoleSizeMicrons") / pixelAreaMicrons;
        } else {
            minFragmentSize = this.params.getDoubleParameterValue("minFragmentSizePixels");
            maxHoleSizeTemp = this.params.getDoubleParameterValue("maxHoleSizePixels");
        }
        double maxHoleSize = maxHoleSizeTemp < 0.0 ? Double.POSITIVE_INFINITY : maxHoleSizeTemp;
        PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
        LinkedHashSet previousSelection = new LinkedHashSet(hierarchy.getSelectionModel().getSelectedObjects());
        tasks.add(() -> {
            HashSet<PathObject> toRemove = new HashSet<PathObject>();
            HashMap<PathROIObject, ROI> toUpdate = new HashMap<PathROIObject, ROI>();
            for (PathObject pathObject : parentObjects) {
                ROI roiOrig = pathObject.getROI();
                if (roiOrig == null || !roiOrig.isArea()) continue;
                ROI roiUpdated = RoiTools.removeSmallPieces((ROI)roiOrig, (double)minFragmentSize, (double)maxHoleSize);
                if (roiUpdated == null || roiUpdated.isEmpty()) {
                    toRemove.add(pathObject);
                    continue;
                }
                if (roiOrig == roiUpdated || !(pathObject instanceof PathROIObject)) continue;
                toUpdate.put((PathROIObject)pathObject, roiUpdated);
            }
            if (toRemove.isEmpty() && toUpdate.isEmpty()) {
                return;
            }
            hierarchy.getSelectionModel().clearSelection();
            if (!toRemove.isEmpty()) {
                hierarchy.removeObjects(toRemove, true);
            }
            if (!toUpdate.isEmpty()) {
                hierarchy.removeObjects(toUpdate.keySet(), true);
                toUpdate.forEach((p, r) -> p.setROI(r));
                hierarchy.addObjects(toUpdate.keySet());
            }
            previousSelection.removeAll(toRemove);
            if (previousSelection.size() == 1) {
                hierarchy.getSelectionModel().setSelectedObject((PathObject)previousSelection.iterator().next());
            } else if (previousSelection.size() > 1) {
                hierarchy.getSelectionModel().selectObjects((Collection)previousSelection);
                if (selected != null && !toRemove.contains(selected)) {
                    hierarchy.getSelectionModel().setSelectedObject(selected, true);
                }
            }
        });
        return tasks;
    }
}

