/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import qupath.lib.geom.Point2;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.AbstractInteractivePlugin;
import qupath.lib.plugins.PathTask;
import qupath.lib.plugins.TaskRunner;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.roi.ConvexHull;

public class FindConvexHullDetectionsPlugin<T>
extends AbstractInteractivePlugin<T> {
    private static final String commandName = "Find convex hull detections (TMA)";
    private transient AtomicInteger nObjectsRemoved = new AtomicInteger();

    static List<PathObject> getConvexHullDetections(PathObjectHierarchy hierarchy, PathObject parent, int nIterations) {
        HashMap<Point2, PathObject> pointsMap = new HashMap<Point2, PathObject>();
        ArrayList<PathObject> convexDetections = new ArrayList<PathObject>();
        Collection pathObjects = PathObjectTools.getDescendantObjects((PathObject)parent, null, PathDetectionObject.class);
        if (pathObjects.isEmpty()) {
            return Collections.emptyList();
        }
        pointsMap.clear();
        for (PathObject child : pathObjects) {
            if (!child.hasROI()) continue;
            pointsMap.put(new Point2(child.getROI().getCentroidX(), child.getROI().getCentroidY()), child);
        }
        ArrayList points = new ArrayList(pointsMap.keySet());
        for (int i = 0; i < nIterations; ++i) {
            List convexPoints = ConvexHull.getConvexHull(points);
            if (convexPoints == null) continue;
            for (Point2 p : convexPoints) {
                convexDetections.add((PathObject)pointsMap.get(p));
            }
            points.removeAll(convexPoints);
        }
        return convexDetections;
    }

    public String getName() {
        return commandName;
    }

    public String getDescription() {
        return "Iteratively remove detections at the boundary of a TMA core";
    }

    public String getLastResultsDescription() {
        String process;
        boolean deleteImmediately = Boolean.TRUE.equals(this.params.getBooleanParameterValue("deleteImmediately"));
        String string = process = deleteImmediately ? "Removed " : "Selected ";
        if (Boolean.TRUE.equals(this.params.getBooleanParameterValue("deleteImmediately")) && this.nObjectsRemoved.get() == 1) {
            return process + " 1 object";
        }
        return process + this.nObjectsRemoved.get() + " objects";
    }

    protected Collection<? extends PathObject> getParentObjects(ImageData<T> imageData) {
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
        if (selected instanceof TMACoreObject) {
            return Collections.singleton(selected);
        }
        if (hierarchy.getTMAGrid() != null) {
            return hierarchy.getTMAGrid().getTMACoreList();
        }
        return Collections.emptyList();
    }

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        return Collections.singleton(TMACoreObject.class);
    }

    public ParameterList getDefaultParameterList(ImageData<T> imageData) {
        return new ParameterList().addIntParameter("nIterations", "Number of iterations", 10, null, "Number of times to iteratively identify detections from the convex hull of the detection centroids").addBooleanParameter("deleteImmediately", "Delete immediately", false, "Immediately delete detections, rather than selecting them only");
    }

    public boolean runPlugin(TaskRunner taskRunner, ImageData<T> imageData, String arg) {
        this.nObjectsRemoved.set(0);
        return super.runPlugin(taskRunner, imageData, arg);
    }

    protected void addRunnableTasks(final ImageData<T> imageData, final PathObject parentObject, List<Runnable> tasks) {
        final boolean deleteImmediately = Boolean.TRUE.equals(this.params.getBooleanParameterValue("deleteImmediately"));
        tasks.add((Runnable)new PathTask(){
            private List<PathObject> toRemove;
            private int nRemoved;

            public void run() {
                this.toRemove = FindConvexHullDetectionsPlugin.getConvexHullDetections(imageData.getHierarchy(), parentObject, FindConvexHullDetectionsPlugin.this.params.getIntParameterValue("nIterations"));
                this.nRemoved = this.toRemove.size();
            }

            public void taskComplete(boolean wasCancelled) {
                if (wasCancelled) {
                    return;
                }
                if (this.toRemove != null && !this.toRemove.isEmpty()) {
                    if (deleteImmediately) {
                        imageData.getHierarchy().removeObjects(this.toRemove, false);
                    } else {
                        imageData.getHierarchy().getSelectionModel().deselectObject(parentObject);
                        imageData.getHierarchy().getSelectionModel().selectObjects(this.toRemove);
                    }
                    this.toRemove = null;
                    FindConvexHullDetectionsPlugin.this.nObjectsRemoved.addAndGet(this.nRemoved);
                }
            }

            public String getLastResultsDescription() {
                String process;
                String string = process = deleteImmediately ? "Removed " : "Selected ";
                if (Boolean.TRUE.equals(FindConvexHullDetectionsPlugin.this.params.getBooleanParameterValue("deleteImmediately")) && this.nRemoved == 1) {
                    return process + " 1 object";
                }
                return process + this.nRemoved + " objects";
            }
        });
    }
}

