/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathROIObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.AbstractInteractivePlugin;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class FillAnnotationHolesPlugin<T>
extends AbstractInteractivePlugin<T> {
    private String resultString = null;

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        return Collections.singleton(PathAnnotationObject.class);
    }

    public String getName() {
        return "Fill annotation holes";
    }

    public String getDescription() {
        return "Fill holes occurring within selected annotations (AreaROIs or some PolygonROIs)";
    }

    public String getLastResultsDescription() {
        return this.resultString;
    }

    public ParameterList getDefaultParameterList(ImageData<T> imageData) {
        return new ParameterList();
    }

    protected Collection<? extends PathObject> getParentObjects(ImageData<T> imageData) {
        return imageData.getHierarchy().getSelectionModel().getSelectedObjects().stream().filter(p -> p.isAnnotation()).toList();
    }

    protected void addRunnableTasks(ImageData<T> imageData, PathObject parentObject, List<Runnable> tasks) {
    }

    protected Collection<Runnable> getTasks(ImageData<T> imageData) {
        Collection<PathObject> parentObjects = this.getParentObjects(imageData);
        if (parentObjects == null || parentObjects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(1);
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
        ArrayList previousSelection = new ArrayList(hierarchy.getSelectionModel().getSelectedObjects());
        tasks.add(() -> {
            HashMap<PathROIObject, ROI> toUpdate = new HashMap<PathROIObject, ROI>();
            for (PathObject pathObject : parentObjects) {
                ROI roiOrig = pathObject.getROI();
                if (roiOrig == null || !roiOrig.isArea()) continue;
                ROI roiUpdated = roiOrig;
                if (roiOrig == (roiUpdated = RoiTools.fillHoles((ROI)roiUpdated)) || !(pathObject instanceof PathROIObject)) continue;
                toUpdate.put((PathROIObject)pathObject, roiUpdated);
            }
            if (toUpdate.isEmpty()) {
                return;
            }
            hierarchy.getSelectionModel().clearSelection();
            if (!toUpdate.isEmpty()) {
                hierarchy.removeObjects(toUpdate.keySet(), true);
                toUpdate.forEach((p, r) -> p.setROI(r));
                hierarchy.addObjects(toUpdate.keySet());
            }
            hierarchy.getSelectionModel().selectObjects(previousSelection);
            hierarchy.getSelectionModel().setSelectedObject(selected, true);
        });
        return tasks;
    }
}

