/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.plugins.objects;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.AbstractInteractivePlugin;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.interfaces.ROI;

public class DilateAnnotationPlugin<T>
extends AbstractInteractivePlugin<T> {
    private static Logger logger = LoggerFactory.getLogger(DilateAnnotationPlugin.class);
    private ParameterList params = new ParameterList().addDoubleParameter("radiusMicrons", "Expansion radius", 100.0, GeneralTools.micrometerSymbol(), "Distance to expand ROI").addDoubleParameter("radiusPixels", "Expansion radius", 100.0, "px", "Distance to expand ROI").addChoiceParameter("lineCap", "Line cap", (Object)LineCap.ROUND, Arrays.asList(LineCap.values()), "Method to handle end points when expanding lines (not important when expanding areas)").addBooleanParameter("removeInterior", "Remove interior", false, "Create annotation containing only the expanded region, with the original ROI removed").addBooleanParameter("constrainToParent", "Constrain to parent", true, "Constrain ROI to fit inside the ROI of the parent object");
    private String resultString = null;

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        return Collections.singleton(PathAnnotationObject.class);
    }

    public String getName() {
        return "Expand annotations";
    }

    public String getDescription() {
        return "Expand annotation object ROIs";
    }

    public String getLastResultsDescription() {
        return this.resultString;
    }

    public ParameterList getDefaultParameterList(ImageData<T> imageData) {
        boolean hasMicrons = imageData.getServer().getPixelCalibration().hasPixelSizeMicrons();
        this.params.setHiddenParameters(hasMicrons, new String[]{"radiusPixels"});
        this.params.setHiddenParameters(!hasMicrons, new String[]{"radiusMicrons"});
        return this.params;
    }

    protected Collection<? extends PathObject> getParentObjects(ImageData<T> imageData) {
        return imageData.getHierarchy().getSelectionModel().getSelectedObjects().stream().filter(p -> p.isAnnotation()).toList();
    }

    protected void addRunnableTasks(ImageData<T> imageData, PathObject parentObject, List<Runnable> tasks) {
    }

    protected Collection<Runnable> getTasks(ImageData<T> imageData) {
        Collection<PathObject> parentObjects = this.getParentObjects(imageData);
        if (parentObjects == null || parentObjects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(parentObjects.size());
        ImageServer server = imageData.getServer();
        Rectangle bounds = new Rectangle(0, 0, server.getWidth(), server.getHeight());
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        PixelCalibration cal = server.getPixelCalibration();
        double radiusPixels = cal.hasPixelSizeMicrons() ? this.params.getDoubleParameterValue("radiusMicrons") / cal.getAveragedPixelSizeMicrons() : this.params.getDoubleParameterValue("radiusPixels");
        boolean constrainToParent = this.params.getBooleanParameterValue("constrainToParent");
        boolean removeInterior = this.params.getBooleanParameterValue("removeInterior");
        LineCap cap = this.params.containsKey((Object)"lineCap") ? (LineCap)((Object)this.params.getChoiceParameterValue("lineCap")) : LineCap.ROUND;
        PathObject selected = hierarchy.getSelectionModel().getSelectedObject();
        ArrayList previousSelection = new ArrayList(hierarchy.getSelectionModel().getSelectedObjects());
        tasks.add(() -> {
            for (PathObject pathObject : parentObjects) {
                DilateAnnotationPlugin.addExpandedAnnotation(bounds, hierarchy, pathObject, radiusPixels, constrainToParent, removeInterior, cap);
            }
            hierarchy.getSelectionModel().selectObjects(previousSelection);
            hierarchy.getSelectionModel().setSelectedObject(selected, true);
        });
        return tasks;
    }

    private static void addExpandedAnnotation(Rectangle bounds, PathObjectHierarchy hierarchy, PathObject pathObject, double radiusPixels, boolean constrainToParent, boolean removeInterior, LineCap cap) {
        ROI roi2;
        PathObject parent;
        ROI roi = pathObject.getROI();
        Geometry geometry = roi.getGeometry();
        int capVal = 1;
        if (cap == LineCap.FLAT) {
            capVal = 2;
        } else if (cap == LineCap.SQUARE) {
            capVal = 3;
        }
        Geometry geometry2 = BufferOp.bufferOp((Geometry)geometry, (double)radiusPixels, (int)8, (int)capVal);
        boolean isErosion = radiusPixels < 0.0;
        PathObject pathObject2 = parent = isErosion ? pathObject : pathObject.getParent();
        if (constrainToParent && !isErosion) {
            Geometry parentShape = parent == null || parent.getROI() == null ? ROIs.createRectangleROI((double)bounds.getX(), (double)bounds.getY(), (double)bounds.getWidth(), (double)bounds.getHeight(), (ImagePlane)ImagePlane.getPlane((ROI)roi)).getGeometry() : parent.getROI().getGeometry();
            geometry2 = geometry2.intersection(parentShape);
        }
        if (removeInterior) {
            if (isErosion) {
                geometry = GeometryTools.homogenizeGeometryCollection((Geometry)geometry);
                geometry2 = geometry.difference(geometry2);
            } else {
                if (geometry.getArea() == 0.0) {
                    geometry = geometry.buffer(0.5);
                }
                geometry2 = GeometryTools.homogenizeGeometryCollection((Geometry)geometry2);
                geometry = GeometryTools.homogenizeGeometryCollection((Geometry)geometry);
                geometry2 = geometry2.difference(geometry);
            }
        }
        if ((roi2 = GeometryTools.geometryToROI((Geometry)geometry2, (ImagePlane)ImagePlane.getPlane((ROI)roi))).isEmpty()) {
            logger.debug("Updated ROI is empty after {} px expansion", (Object)radiusPixels);
            return;
        }
        PathObject annotation2 = PathObjects.createAnnotationObject((ROI)roi2, (PathClass)pathObject.getPathClass());
        annotation2.setName(pathObject.getName());
        annotation2.setColor(pathObject.getColor());
        if (constrainToParent || isErosion) {
            hierarchy.addObjectBelowParent(parent, annotation2, true);
        } else {
            hierarchy.addObject(annotation2);
        }
    }

    public static enum LineCap {
        ROUND,
        FLAT,
        SQUARE;


        public String toString() {
            switch (this.ordinal()) {
                case 1: {
                    return "Flat";
                }
                case 0: {
                    return "Round";
                }
                case 2: {
                    return "Square";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

