/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import qupath.lib.lazy.interfaces.LazyStringValue;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.TMACoreObject;

class TMACoreNameValue
implements LazyStringValue<PathObject> {
    TMACoreNameValue() {
    }

    @Override
    public String getHelpText() {
        return "The name of the selected tissue microarray (TMA) core";
    }

    @Override
    public String getName() {
        return "TMA Core";
    }

    private TMACoreObject getAncestorTMACore(PathObject pathObject) {
        if (pathObject == null) {
            return null;
        }
        if (pathObject instanceof TMACoreObject) {
            TMACoreObject core = (TMACoreObject)pathObject;
            return core;
        }
        return this.getAncestorTMACore(pathObject.getParent());
    }

    @Override
    public String getValue(PathObject pathObject) {
        TMACoreObject core = this.getAncestorTMACore(pathObject);
        if (core == null) {
            return null;
        }
        return core.getDisplayedName();
    }
}

