/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import qupath.lib.images.ImageData;
import qupath.lib.lazy.interfaces.LazyNumericValue;
import qupath.lib.objects.PathObject;

abstract class ROIValue
implements LazyNumericValue<PathObject> {
    private final ImageData<?> imageData;

    ROIValue(ImageData<?> imageData) {
        this.imageData = imageData;
    }

    protected boolean hasPixelSizeMicrons() {
        return this.imageData != null && this.imageData.getServerMetadata().getPixelCalibration().hasPixelSizeMicrons();
    }

    protected double pixelWidthMicrons() {
        if (this.hasPixelSizeMicrons()) {
            return this.imageData.getServerMetadata().getPixelCalibration().getPixelWidthMicrons();
        }
        return Double.NaN;
    }

    protected double pixelHeightMicrons() {
        if (this.hasPixelSizeMicrons()) {
            return this.imageData.getServerMetadata().getPixelCalibration().getPixelHeightMicrons();
        }
        return Double.NaN;
    }
}

