/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.lazy.objects.ROIValue;
import qupath.lib.objects.PathObject;
import qupath.lib.roi.interfaces.ROI;

class ROICentroidValue
extends ROIValue {
    private CentroidType type;

    ROICentroidValue(ImageData<?> imageData, CentroidType type) {
        super(imageData);
        this.type = type;
    }

    @Override
    public String getHelpText() {
        return "The location of the ROI centroid";
    }

    @Override
    public String getName() {
        return String.format("Centroid %s %s", new Object[]{this.type, this.hasPixelSizeMicrons() ? GeneralTools.micrometerSymbol() : "px"});
    }

    private Double getCentroid(ROI roi) {
        if (roi == null || this.type == null) {
            return null;
        }
        if (this.hasPixelSizeMicrons()) {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> roi.getCentroidX() * this.pixelWidthMicrons();
                case 1 -> roi.getCentroidY() * this.pixelHeightMicrons();
            };
        }
        return switch (this.type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> roi.getCentroidX();
            case 1 -> roi.getCentroidY();
        };
    }

    @Override
    public Number getValue(PathObject pathObject) {
        return this.getCentroid(pathObject.getROI());
    }

    static enum CentroidType {
        X,
        Y;

    }
}

