/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import java.util.function.Function;
import qupath.lib.lazy.objects.DetectionCountValue;
import qupath.lib.lazy.objects.DetectionPathClassCounts;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;

class PositivePercentageValue
extends DetectionCountValue {
    private PathClass[] parentClasses;

    PositivePercentageValue(Function<PathObject, DetectionPathClassCounts> countsFunction, PathClass ... parentClasses) {
        super(countsFunction);
        this.parentClasses = parentClasses;
    }

    @Override
    public String getHelpText() {
        String pcString = this.getParentClassificationsString(this.parentClasses);
        if (pcString.isEmpty()) {
            return "Number of detection classified as 'Positive' / ('Positive' + 'Negative') * 100%";
        }
        return "Number of detection classified as '" + pcString + ": Positive' / ('" + pcString + ": Positive' + '" + pcString + ": Negative') * 100%";
    }

    @Override
    public String getName() {
        return this.getNameForClasses("Positive %", this.parentClasses);
    }

    @Override
    public Number computeValue(PathObject pathObject, DetectionPathClassCounts counts) {
        return counts.getPositivePercentage(this.parentClasses);
    }
}

