/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import qupath.lib.lazy.interfaces.LazyNumericValue;
import qupath.lib.objects.PathObject;
import qupath.opencv.ml.pixel.PixelClassificationMeasurementManager;

class PixelClassifierValue
implements LazyNumericValue<PathObject> {
    private PixelClassificationMeasurementManager manager;
    private String name;

    PixelClassifierValue(PixelClassificationMeasurementManager manager, String name) {
        this.manager = manager;
        this.name = name;
    }

    @Override
    public String getName() {
        return "(Live)" + this.name;
    }

    @Override
    public String getHelpText() {
        return "A temporary measurement made by the current pixel classifier";
    }

    @Override
    public Number getValue(PathObject pathObject) {
        return this.manager.getCachedMeasurementValue(pathObject, this.name);
    }
}

