/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.lazy.objects.ROIValue;
import qupath.lib.objects.PathObject;
import qupath.lib.roi.interfaces.ROI;

class PerimeterValue
extends ROIValue {
    PerimeterValue(ImageData<?> imageData) {
        super(imageData);
    }

    @Override
    public String getHelpText() {
        return "Perimeter of the selected object's ROI";
    }

    @Override
    public String getName() {
        return this.hasPixelSizeMicrons() ? "Perimeter " + GeneralTools.micrometerSymbol() : "Perimeter px";
    }

    @Override
    public Number getValue(PathObject pathObject) {
        ROI roi = pathObject.getROI();
        if (roi == null || !roi.isArea()) {
            return Double.NaN;
        }
        if (this.hasPixelSizeMicrons()) {
            return roi.getScaledLength(this.pixelWidthMicrons(), this.pixelHeightMicrons());
        }
        return roi.getLength();
    }
}

