/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.function.Function;
import java.util.function.Supplier;
import qupath.lib.images.ImageData;
import qupath.lib.lazy.interfaces.LazyBooleanValue;
import qupath.lib.lazy.interfaces.LazyNumericValue;
import qupath.lib.lazy.interfaces.LazyStringValue;
import qupath.lib.lazy.objects.AllredIntensityValue;
import qupath.lib.lazy.objects.AllredProportionValue;
import qupath.lib.lazy.objects.AllredValue;
import qupath.lib.lazy.objects.ClassDensityValue;
import qupath.lib.lazy.objects.DetectionClassificationCounter;
import qupath.lib.lazy.objects.DetectionClassificationsCountValue;
import qupath.lib.lazy.objects.DetectionPathClassCounts;
import qupath.lib.lazy.objects.HScoreValue;
import qupath.lib.lazy.objects.ImageNameValue;
import qupath.lib.lazy.objects.LineLengthValue;
import qupath.lib.lazy.objects.MeasurementListValue;
import qupath.lib.lazy.objects.MissingTMACoreValue;
import qupath.lib.lazy.objects.NumPointsValue;
import qupath.lib.lazy.objects.ObjectIdValue;
import qupath.lib.lazy.objects.ObjectNameValue;
import qupath.lib.lazy.objects.ObjectTypeCountValue;
import qupath.lib.lazy.objects.ObjectTypeValue;
import qupath.lib.lazy.objects.ParentNameValue;
import qupath.lib.lazy.objects.PathClassValue;
import qupath.lib.lazy.objects.PerimeterValue;
import qupath.lib.lazy.objects.PixelClassifierValue;
import qupath.lib.lazy.objects.PositivePercentageValue;
import qupath.lib.lazy.objects.ROIAreaValue;
import qupath.lib.lazy.objects.ROICentroidValue;
import qupath.lib.lazy.objects.ROINameValue;
import qupath.lib.lazy.objects.StringMetadataValue;
import qupath.lib.lazy.objects.TMACoreNameValue;
import qupath.lib.lazy.objects.TimepointValue;
import qupath.lib.lazy.objects.ZSliceValue;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;
import qupath.opencv.ml.pixel.PixelClassificationMeasurementManager;

public class PathObjectLazyValues {
    private static final Cache<ImageData<?>, DetectionClassificationCounter> countsMap = CacheBuilder.newBuilder().weakKeys().weakValues().build();
    public static final LazyStringValue<PathObject> CLASSIFICATION = new PathClassValue();
    public static final LazyStringValue<PathObject> PARENT_DISPLAYED_NAME = new ParentNameValue();
    public static final LazyStringValue<PathObject> OBJECT_TYPE = new ObjectTypeValue();
    public static final LazyStringValue<PathObject> OBJECT_ID = new ObjectIdValue();
    public static final LazyStringValue<PathObject> OBJECT_NAME = new ObjectNameValue();
    public static final LazyStringValue<PathObject> TMA_CORE_NAME = new TMACoreNameValue();
    public static final LazyStringValue<PathObject> ROI_TYPE = new ROINameValue();
    public static LazyBooleanValue<PathObject> TMA_CORE_MISSING = new MissingTMACoreValue();
    public static LazyNumericValue<PathObject> ROI_Z_SLICE = new ZSliceValue();
    public static LazyNumericValue<PathObject> ROI_TIMEPOINT = new TimepointValue();
    public static LazyNumericValue<PathObject> ROI_NUM_POINTS = new NumPointsValue();

    private static synchronized Function<PathObject, DetectionPathClassCounts> getCountsFunction(ImageData<?> imageData) {
        DetectionClassificationCounter counts = (DetectionClassificationCounter)countsMap.getIfPresent(imageData);
        if (counts == null) {
            counts = new DetectionClassificationCounter(imageData.getHierarchy());
            countsMap.put(imageData, (Object)counts);
        }
        return counts;
    }

    public static LazyStringValue<PathObject> createImageNameMeasurement(ImageData<?> imageData) {
        return new ImageNameValue(imageData);
    }

    public static LazyNumericValue<PathObject> createROICentroidX(ImageData<?> imageData) {
        return new ROICentroidValue(imageData, ROICentroidValue.CentroidType.X);
    }

    public static LazyNumericValue<PathObject> createROICentroidY(ImageData<?> imageData) {
        return new ROICentroidValue(imageData, ROICentroidValue.CentroidType.Y);
    }

    public static LazyNumericValue<PathObject> createROIAreaMeasurement(ImageData<?> imageData) {
        return new ROIAreaValue(imageData);
    }

    public static LazyNumericValue<PathObject> createROIPerimeterMeasurement(ImageData<?> imageData) {
        return new PerimeterValue(imageData);
    }

    public static LazyNumericValue<PathObject> createROILengthMeasurement(ImageData<?> imageData) {
        return new LineLengthValue(imageData);
    }

    public static LazyNumericValue<PathObject> createDetectionCountMeasurement(ImageData<?> imageData) {
        return new ObjectTypeCountValue(imageData, PathDetectionObject.class);
    }

    public static LazyNumericValue<PathObject> createLivePixelClassificationMeasurement(PixelClassificationMeasurementManager manager, String name) {
        return new PixelClassifierValue(manager, name);
    }

    public static LazyStringValue<PathObject> createMetadataMeasurement(String name) {
        return new StringMetadataValue(name);
    }

    public static LazyNumericValue<PathObject> createMeasurementListMeasurement(String name) {
        return new MeasurementListValue(name);
    }

    public static LazyNumericValue<PathObject> createHScoreMeasurement(ImageData<?> imageData, PathClass ... pathClasses) {
        return new HScoreValue(PathObjectLazyValues.getCountsFunction(imageData), pathClasses);
    }

    public static LazyNumericValue<PathObject> createPositivePercentageMeasurement(ImageData<?> imageData, PathClass ... pathClasses) {
        return new PositivePercentageValue(PathObjectLazyValues.getCountsFunction(imageData), pathClasses);
    }

    public static LazyNumericValue<PathObject> createDetectionClassDensityMeasurement(ImageData<?> imageData, PathClass pathClass) {
        return new ClassDensityValue(PathObjectLazyValues.getCountsFunction(imageData), imageData, pathClass);
    }

    public static LazyNumericValue<PathObject> createBaseClassCountsMeasurement(ImageData<?> imageData, PathClass pathClass) {
        return new DetectionClassificationsCountValue(PathObjectLazyValues.getCountsFunction(imageData), pathClass, true);
    }

    public static LazyNumericValue<PathObject> createExactClassCountsMeasurement(ImageData<?> imageData, PathClass pathClass) {
        return new DetectionClassificationsCountValue(PathObjectLazyValues.getCountsFunction(imageData), pathClass, false);
    }

    public static LazyNumericValue<PathObject> createAllredIntensityMeasurement(ImageData<?> imageData, Supplier<Double> allredMinPercentage, PathClass ... pathClasses) {
        return new AllredIntensityValue(PathObjectLazyValues.getCountsFunction(imageData), allredMinPercentage, pathClasses);
    }

    public static LazyNumericValue<PathObject> createAllredProportionMeasurement(ImageData<?> imageData, Supplier<Double> allredMinPercentage, PathClass ... pathClasses) {
        return new AllredProportionValue(PathObjectLazyValues.getCountsFunction(imageData), allredMinPercentage, pathClasses);
    }

    public static LazyNumericValue<PathObject> createAllredMeasurement(ImageData<?> imageData, Supplier<Double> allredMinPercentage, PathClass ... pathClasses) {
        return new AllredValue(PathObjectLazyValues.getCountsFunction(imageData), allredMinPercentage, pathClasses);
    }
}

