/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import java.util.Collection;
import qupath.lib.images.ImageData;
import qupath.lib.lazy.interfaces.LazyNumericValue;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;

class ObjectTypeCountValue
implements LazyNumericValue<PathObject> {
    private final ImageData<?> imageData;
    private final Class<? extends PathObject> cls;

    public ObjectTypeCountValue(ImageData<?> imageData, Class<? extends PathObject> cls) {
        this.imageData = imageData;
        this.cls = cls;
    }

    @Override
    public String getHelpText() {
        return "Number of objects with type '" + PathObjectTools.getSuitableName(this.cls, (boolean)false) + "'";
    }

    @Override
    public String getName() {
        return "Num " + PathObjectTools.getSuitableName(this.cls, (boolean)true);
    }

    @Override
    public Number getValue(PathObject pathObject) {
        PathObjectHierarchy hierarchy = this.imageData.getHierarchy();
        Collection pathObjects = pathObject.isRootObject() ? hierarchy.getObjects(null, this.cls) : hierarchy.getObjectsForROI(this.cls, pathObject.getROI());
        pathObjects.remove(pathObject);
        return pathObjects.size();
    }

    public String toString() {
        return this.getName();
    }
}

