/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.lazy.interfaces.LazyStringValue;
import qupath.lib.objects.PathObject;

class ObjectIdValue
implements LazyStringValue<PathObject> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectIdValue.class);

    ObjectIdValue() {
    }

    @Override
    public String getName() {
        return "Object ID";
    }

    @Override
    public String getHelpText() {
        return "Universal Unique Identifier for the selected object";
    }

    @Override
    public String getValue(PathObject pathObject) {
        UUID id = pathObject.getID();
        if (id == null) {
            logger.warn("ID null for {}", (Object)pathObject);
            return null;
        }
        return id.toString();
    }
}

