/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import qupath.lib.lazy.interfaces.LazyNumericValue;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathObject;

public class MeasurementListValue
implements LazyNumericValue<PathObject> {
    private final String name;

    MeasurementListValue(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHelpText() {
        return "'" + this.name + "' value from the object's measurement list";
    }

    @Override
    public Number getValue(PathObject pathObject) {
        if (pathObject != null) {
            MeasurementList ml = pathObject.getMeasurementList();
            double val = ml.get(this.name);
            if (Double.isNaN(val) && !ml.containsKey(this.name)) {
                return null;
            }
            return val;
        }
        return null;
    }
}

