/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.lazy.objects.ROIValue;
import qupath.lib.objects.PathObject;
import qupath.lib.roi.interfaces.ROI;

class LineLengthValue
extends ROIValue {
    LineLengthValue(ImageData<?> imageData) {
        super(imageData);
    }

    @Override
    public String getHelpText() {
        return "Length of the selected object's line ROI";
    }

    @Override
    public String getName() {
        return this.hasPixelSizeMicrons() ? "Length " + GeneralTools.micrometerSymbol() : "Length px";
    }

    @Override
    public Number getValue(PathObject pathObject) {
        ROI roi = pathObject.getROI();
        if (roi == null || !roi.isLine()) {
            return Double.NaN;
        }
        if (this.hasPixelSizeMicrons()) {
            return roi.getScaledLength(this.pixelWidthMicrons(), this.pixelHeightMicrons());
        }
        return roi.getLength();
    }
}

