/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import qupath.lib.images.ImageData;
import qupath.lib.lazy.interfaces.LazyStringValue;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;

class ImageNameValue
implements LazyStringValue<PathObject> {
    private final ImageData<?> imageData;

    ImageNameValue(ImageData<?> imageData) {
        this.imageData = imageData;
    }

    @Override
    public String getName() {
        return "Image";
    }

    @Override
    public String getHelpText() {
        return "Name for the current image";
    }

    @Override
    public String getValue(PathObject pathObject) {
        if (this.imageData == null) {
            return null;
        }
        PathObjectHierarchy hierarchy = this.imageData.getHierarchy();
        if (PathObjectTools.hierarchyContainsObject((PathObjectHierarchy)hierarchy, (PathObject)pathObject)) {
            return this.imageData.getServerMetadata().getName();
        }
        return null;
    }
}

