/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import java.util.function.Function;
import qupath.lib.lazy.objects.DetectionCountValue;
import qupath.lib.lazy.objects.DetectionPathClassCounts;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;

class HScoreValue
extends DetectionCountValue {
    private final PathClass[] pathClasses;

    HScoreValue(Function<PathObject, DetectionPathClassCounts> countsFunction, PathClass ... pathClasses) {
        super(countsFunction);
        this.pathClasses = pathClasses;
    }

    @Override
    public String getHelpText() {
        String pcString = this.getParentClassificationsString(this.pathClasses);
        if (pcString.isEmpty()) {
            return "H-score calculated from Negative, 1+, 2+ and 3+ classified detections (range 0-300)";
        }
        return "H-score calculated from " + pcString + ": Negative, 1+, 2+ and 3+ classified detections (range 0-300)";
    }

    @Override
    public String getName() {
        return this.getNameForClasses("H-score", this.pathClasses);
    }

    @Override
    public Number computeValue(PathObject pathObject, DetectionPathClassCounts counts) {
        return counts.getHScore(this.pathClasses);
    }
}

