/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;

class DetectionPathClassCounts {
    private final Map<PathClass, Integer> counts = new HashMap<PathClass, Integer>();

    DetectionPathClassCounts(PathObjectHierarchy hierarchy, PathObject parentObject) {
        Collection pathObjects = parentObject.isRootObject() ? hierarchy.getDetectionObjects() : hierarchy.getAllDetectionsForROI(parentObject.getROI());
        for (PathObject child : pathObjects) {
            if (child == parentObject || !child.isDetection()) continue;
            PathClass pathClass = child.getPathClass();
            this.counts.merge(pathClass, 1, Integer::sum);
        }
    }

    public int getDirectCount(PathClass pathClass) {
        return this.counts.getOrDefault(pathClass, 0);
    }

    public int getCountForAncestor(Predicate<PathClass> predicate, PathClass ancestor) {
        int count = 0;
        for (Map.Entry<PathClass, Integer> entry : this.counts.entrySet()) {
            if (ancestor == null) {
                if (!predicate.test(entry.getKey()) || entry.getKey().getParentClass() != null) continue;
                count += entry.getValue().intValue();
                continue;
            }
            if (!ancestor.isAncestorOf(entry.getKey()) || !predicate.test(entry.getKey())) continue;
            count += entry.getValue().intValue();
        }
        return count;
    }

    public int getCountForAncestor(Predicate<PathClass> predicate, PathClass ... ancestors) {
        int count = 0;
        for (PathClass ancestor : ancestors) {
            count += this.getCountForAncestor(predicate, ancestor);
        }
        return count;
    }

    public int getCountForAncestor(PathClass ... ancestors) {
        return this.getCountForAncestor((PathClass pathClass) -> true, ancestors);
    }

    public int getOnePlus(PathClass ... ancestors) {
        return this.getCountForAncestor(PathClassTools::isOnePlus, ancestors);
    }

    public int getTwoPlus(PathClass ... ancestors) {
        return this.getCountForAncestor(PathClassTools::isTwoPlus, ancestors);
    }

    public int getThreePlus(PathClass ... ancestors) {
        return this.getCountForAncestor(PathClassTools::isThreePlus, ancestors);
    }

    public int getNegative(PathClass ... ancestors) {
        return this.getCountForAncestor(PathClassTools::isNegativeClass, ancestors);
    }

    public int getPositive(PathClass ... ancestors) {
        return this.getCountForAncestor(PathClassTools::isPositiveOrGradedIntensityClass, ancestors);
    }

    public double getHScore(PathClass ... ancestors) {
        double plus1 = 0.0;
        double plus2 = 0.0;
        double plus3 = 0.0;
        double negative = 0.0;
        for (PathClass ancestor : ancestors) {
            plus1 += (double)this.getOnePlus(ancestor);
            plus2 += (double)this.getTwoPlus(ancestor);
            plus3 += (double)this.getThreePlus(ancestor);
            negative += (double)this.getNegative(ancestor);
        }
        return (plus1 * 1.0 + plus2 * 2.0 + plus3 * 3.0) / (plus1 + plus2 + plus3 + negative) * 100.0;
    }

    public int getAllredIntensity(double minProportion, PathClass ... ancestors) {
        int proportionScore = this.getAllredProportion(minProportion, ancestors);
        int intensityScore = 0;
        if (proportionScore > 0) {
            int nPositive = this.getPositive(ancestors);
            double meanIntensity = ((double)this.getOnePlus(ancestors) + (double)this.getTwoPlus(ancestors) * 2.0 + (double)this.getThreePlus(ancestors) * 3.0) / (double)nPositive;
            intensityScore = meanIntensity > 2.3333333333333335 ? 3 : (meanIntensity > 1.6666666666666667 ? 2 : 1);
        }
        return intensityScore;
    }

    public int getAllredProportion(double minProportion, PathClass ... ancestors) {
        double proportion = this.getPositivePercentage(ancestors) / 100.0;
        if (proportion < minProportion) {
            return 0;
        }
        int proportionScore = proportion >= 0.6666666666666666 ? 5 : (proportion >= 0.3333333333333333 ? 4 : (proportion >= 0.1 ? 3 : (proportion >= 0.01 ? 2 : (proportion > 0.0 ? 1 : 0))));
        return proportionScore;
    }

    public int getAllredScore(double minProportion, PathClass ... ancestors) {
        return this.getAllredIntensity(minProportion, ancestors) + this.getAllredProportion(minProportion, ancestors);
    }

    public double getPositivePercentage(PathClass ... ancestors) {
        double positive = 0.0;
        double negative = 0.0;
        for (PathClass ancestor : ancestors) {
            positive += (double)this.getPositive(ancestor);
            negative += (double)this.getNegative(ancestor);
        }
        return positive / (positive + negative) * 100.0;
    }
}

