/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import qupath.lib.lazy.interfaces.LazyNumericValue;
import qupath.lib.lazy.objects.DetectionPathClassCounts;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;

abstract class DetectionCountValue
implements LazyNumericValue<PathObject> {
    private final Function<PathObject, DetectionPathClassCounts> countsFunction;

    DetectionCountValue(Function<PathObject, DetectionPathClassCounts> countsFunction) {
        this.countsFunction = countsFunction;
    }

    protected String getParentClassificationsString(PathClass ... pathClasses) {
        if (pathClasses.length == 0) {
            return "";
        }
        if (pathClasses.length == 1 && (pathClasses[0] == null || pathClasses[0] == PathClass.NULL_CLASS)) {
            return "";
        }
        if (pathClasses.length == 1) {
            return pathClasses[0].toString();
        }
        return "(" + Arrays.stream(pathClasses).map(p -> p == null ? "<Unclassified>" : p.toString()).collect(Collectors.joining("|")) + ")";
    }

    protected String getNameForClasses(String measurementName, PathClass ... parentClasses) {
        if (parentClasses == null || parentClasses.length == 0) {
            return measurementName;
        }
        if (parentClasses.length == 1) {
            PathClass parent = parentClasses[0];
            if (parent == null) {
                return measurementName;
            }
            return parent.getBaseClass().toString() + ": " + measurementName;
        }
        Object[] names = new String[parentClasses.length];
        for (int i = 0; i < names.length; ++i) {
            PathClass parent = parentClasses[i];
            names[i] = parent == null ? "" : parent.getName();
        }
        Arrays.sort(names);
        return String.join((CharSequence)" + ", (CharSequence[])names) + ": " + measurementName;
    }

    @Override
    public Number getValue(PathObject pathObject) {
        DetectionPathClassCounts counts = this.countsFunction.apply(pathObject);
        if (counts == null) {
            return null;
        }
        return this.computeValue(pathObject, counts);
    }

    protected abstract Number computeValue(PathObject var1, DetectionPathClassCounts var2);

    public String toString() {
        return this.getName();
    }
}

