/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import java.util.function.Function;
import qupath.lib.lazy.objects.DetectionCountValue;
import qupath.lib.lazy.objects.DetectionPathClassCounts;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;

class DetectionClassificationsCountValue
extends DetectionCountValue {
    private final PathClass pathClass;
    private final boolean baseClassification;

    DetectionClassificationsCountValue(Function<PathObject, DetectionPathClassCounts> countsFunction, PathClass pathClass, boolean baseClassification) {
        super(countsFunction);
        this.pathClass = pathClass;
        this.baseClassification = baseClassification;
    }

    @Override
    public String getHelpText() {
        if (this.baseClassification) {
            if (this.pathClass == null || this.pathClass == PathClass.NULL_CLASS) {
                return "Number of detection objects with no base classification";
            }
            return "Number of detection objects with the base classification '" + String.valueOf(this.pathClass) + "' (including all sub-classifications)";
        }
        if (this.pathClass == null || this.pathClass == PathClass.NULL_CLASS) {
            return "Number of detection objects with no classification";
        }
        return "Number of detection objects with the exact classification '" + String.valueOf(this.pathClass) + "'";
    }

    @Override
    public String getName() {
        if (this.baseClassification) {
            return "Num " + this.pathClass.toString() + " (base)";
        }
        return "Num " + this.pathClass.toString();
    }

    @Override
    public Number computeValue(PathObject pathObject, DetectionPathClassCounts counts) {
        if (this.baseClassification) {
            return counts.getCountForAncestor(this.pathClass);
        }
        return counts.getDirectCount(this.pathClass);
    }
}

