/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.lazy.objects.DetectionPathClassCounts;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;

class DetectionClassificationCounter
implements Function<PathObject, DetectionPathClassCounts> {
    private static final Logger logger = LoggerFactory.getLogger(DetectionClassificationCounter.class);
    private final PathObjectHierarchy hierarchy;
    private final Map<PathObject, DetectionPathClassCounts> map = Collections.synchronizedMap(new WeakHashMap());
    private long lastHierarchyEventCount;

    DetectionClassificationCounter(PathObjectHierarchy hierarchy) {
        Objects.requireNonNull(hierarchy, "Hierarchy must not be null!");
        this.hierarchy = hierarchy;
    }

    @Override
    public DetectionPathClassCounts apply(PathObject pathObject) {
        long actualTimestamp = this.hierarchy.getEventCount();
        if (actualTimestamp > this.lastHierarchyEventCount) {
            logger.debug("Clearing cached measurements");
            this.map.clear();
            this.lastHierarchyEventCount = actualTimestamp;
        }
        return this.map.computeIfAbsent(pathObject, p -> new DetectionPathClassCounts(this.hierarchy, (PathObject)p));
    }
}

