/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import java.util.function.Function;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.lazy.objects.DetectionCountValue;
import qupath.lib.lazy.objects.DetectionPathClassCounts;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.interfaces.ROI;

class ClassDensityValue
extends DetectionCountValue {
    private final ImageData<?> imageData;
    private final PathClass pathClass;

    ClassDensityValue(Function<PathObject, DetectionPathClassCounts> countsFunction, ImageData<?> imageData, PathClass pathClass) {
        super(countsFunction);
        this.imageData = imageData;
        this.pathClass = pathClass;
    }

    @Override
    public String getHelpText() {
        return "Density of detections with classification '" + String.valueOf(this.pathClass) + "' inside the selected objects";
    }

    @Override
    public String getName() {
        if (this.imageData != null && this.imageData.getServerMetadata().getPixelCalibration().hasPixelSizeMicrons()) {
            return String.format("Num %s per mm^2", this.pathClass.toString());
        }
        return String.format("Num %s per px^2", this.pathClass.toString());
    }

    @Override
    public Number computeValue(PathObject pathObject, DetectionPathClassCounts counts) {
        if (pathObject.isAnnotation() || pathObject.isTMACore() && pathObject.nChildObjects() == 1) {
            return ClassDensityValue.computeDensityPerMM(this.imageData, counts, pathObject, this.pathClass);
        }
        return Double.NaN;
    }

    private static double computeDensityPerMM(ImageData<?> imageData, DetectionPathClassCounts counts, PathObject pathObject, PathClass pathClass) {
        PathObject pathObjectTemp = pathObject;
        if (pathObject instanceof TMACoreObject) {
            PathObject[] children = pathObject.getChildObjectsAsArray();
            if (children.length != 1) {
                return Double.NaN;
            }
            pathObjectTemp = children[0];
        }
        if (pathObjectTemp == null || !pathObjectTemp.isAnnotation() && !pathObjectTemp.isRootObject()) {
            return Double.NaN;
        }
        int n = counts.getCountForAncestor(pathClass);
        ROI roi = pathObjectTemp.getROI();
        ImageServerMetadata serverMetadata = imageData.getServerMetadata();
        if (pathObjectTemp.isRootObject() && serverMetadata.getSizeZ() == 1 && serverMetadata.getSizeT() == 1) {
            roi = ROIs.createRectangleROI((double)0.0, (double)0.0, (double)serverMetadata.getWidth(), (double)serverMetadata.getHeight(), (ImagePlane)ImagePlane.getDefaultPlane());
        }
        if (roi != null && roi.isArea()) {
            PixelCalibration cal;
            double pixelWidth = 1.0;
            double pixelHeight = 1.0;
            PixelCalibration pixelCalibration = cal = serverMetadata == null ? null : serverMetadata.getPixelCalibration();
            if (cal != null && cal.hasPixelSizeMicrons()) {
                pixelWidth = cal.getPixelWidthMicrons() / 1000.0;
                pixelHeight = cal.getPixelHeightMicrons() / 1000.0;
            }
            return (double)n / roi.getScaledArea(pixelWidth, pixelHeight);
        }
        return Double.NaN;
    }
}

