/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import java.util.function.Function;
import java.util.function.Supplier;
import qupath.lib.lazy.objects.AbstractAllredValue;
import qupath.lib.lazy.objects.DetectionPathClassCounts;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;

class AllredValue
extends AbstractAllredValue {
    private final PathClass[] pathClasses;

    AllredValue(Function<PathObject, DetectionPathClassCounts> countsFunction, Supplier<Double> minPositivePercentageSupplier, PathClass ... pathClasses) {
        super(countsFunction, minPositivePercentageSupplier);
        this.pathClasses = pathClasses;
    }

    @Override
    public String getHelpText() {
        return "Sum of Allred proportion and intensity scores (range 0-8)";
    }

    @Override
    public String getName() {
        double minPercentage = this.getMinPositivePercentage();
        String name = minPercentage > 0.0 ? String.format("Allred score (min %.1f%%)", minPercentage) : "Allred score";
        return this.getNameForClasses(name, this.pathClasses);
    }

    @Override
    public Number computeValue(PathObject pathObject, DetectionPathClassCounts counts) {
        return counts.getAllredScore(this.getMinPositivePercentage() / 100.0, this.pathClasses);
    }
}

