/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import java.util.function.Function;
import java.util.function.Supplier;
import qupath.lib.lazy.objects.AbstractAllredValue;
import qupath.lib.lazy.objects.DetectionPathClassCounts;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;

class AllredProportionValue
extends AbstractAllredValue {
    private final PathClass[] pathClasses;

    AllredProportionValue(Function<PathObject, DetectionPathClassCounts> countsFunction, Supplier<Double> minPositivePercentageSupplier, PathClass ... pathClasses) {
        super(countsFunction, minPositivePercentageSupplier);
        this.pathClasses = pathClasses;
    }

    @Override
    public String getHelpText() {
        Object minRequires;
        String pcString = this.getParentClassificationsString(this.pathClasses);
        double minPercentage = this.getMinPositivePercentage();
        Object object = minRequires = minPercentage == 0.0 ? "" : "\nSet to 0 if less than " + minPercentage + "% cells positive";
        if (pcString.isEmpty()) {
            return "Allred proportion score calculated from Negative, 1+, 2+ and 3+ classified detections (range 0-5)" + (String)minRequires;
        }
        return "Allred proportion score calculated from " + pcString + ": Negative, 1+, 2+ and 3+ classified detections (range 0-5)" + (String)minRequires;
    }

    @Override
    public String getName() {
        double minPercentage = this.getMinPositivePercentage();
        String name = minPercentage > 0.0 ? String.format("Allred proportion (min %.1f%%)", minPercentage) : "Allred proportion";
        return this.getNameForClasses(name, this.pathClasses);
    }

    @Override
    public Number computeValue(PathObject pathObject, DetectionPathClassCounts counts) {
        return counts.getAllredProportion(this.getMinPositivePercentage() / 100.0, this.pathClasses);
    }
}

