/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.objects;

import java.util.function.Function;
import java.util.function.Supplier;
import qupath.lib.lazy.objects.AbstractAllredValue;
import qupath.lib.lazy.objects.DetectionPathClassCounts;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;

class AllredIntensityValue
extends AbstractAllredValue {
    private final PathClass[] pathClasses;

    AllredIntensityValue(Function<PathObject, DetectionPathClassCounts> countsFunction, Supplier<Double> minPositivePercentageSupplier, PathClass ... pathClasses) {
        super(countsFunction, minPositivePercentageSupplier);
        this.pathClasses = pathClasses;
    }

    @Override
    public String getHelpText() {
        Object minRequires;
        String pcString = this.getParentClassificationsString(this.pathClasses);
        double minPercentage = this.getMinPositivePercentage();
        Object object = minRequires = minPercentage == 0.0 ? "" : "\nSet to 0 if less than " + minPercentage + "% cells positive";
        if (pcString.isEmpty()) {
            return "Allred intensity score calculated from Negative, 1+, 2+ and 3+ classified detections (range 0-3)" + (String)minRequires;
        }
        return "Allred intensity score calculated from " + pcString + ": Negative, 1+, 2+ and 3+ classified detections (range 0-3)" + (String)minRequires;
    }

    @Override
    public String getName() {
        double minPercentage = this.getMinPositivePercentage();
        String name = minPercentage > 0.0 ? String.format("Allred intensity (min %.1f%%)", minPercentage) : "Allred intensity";
        return this.getNameForClasses(name, this.pathClasses);
    }

    @Override
    public Number computeValue(PathObject pathObject, DetectionPathClassCounts counts) {
        return counts.getAllredIntensity(this.getMinPositivePercentage() / 100.0, this.pathClasses);
    }
}

