/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.interfaces;

import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import qupath.lib.common.GeneralTools;

class ValueFormatter {
    private static final Map<Locale, Map<Integer, NumberFormat>> formatters = new ConcurrentHashMap<Locale, Map<Integer, NumberFormat>>();

    ValueFormatter() {
    }

    static String getStringValue(Object val, int decimalPlaces) {
        Number num;
        if (val == null) {
            return "";
        }
        if (val instanceof Number && ValueFormatter.isFloat(num = (Number)val)) {
            return ValueFormatter.formatNumber(num.doubleValue(), decimalPlaces);
        }
        return Objects.toString(val);
    }

    private static boolean isFloat(Number val) {
        return val instanceof Double || val instanceof Float || !ValueFormatter.isInteger(val);
    }

    private static boolean isInteger(Number val) {
        return val instanceof Integer || val instanceof Long || val instanceof BigInteger || val instanceof Byte || val instanceof Short || val instanceof AtomicInteger || val instanceof AtomicLong;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatNumber(double val, int decimalPlaces) {
        NumberFormat format;
        if (Double.isNaN(val)) {
            return "NaN";
        }
        if (decimalPlaces == 0) {
            return Long.toString(Math.round(val));
        }
        if (decimalPlaces == Integer.MIN_VALUE) {
            return ValueFormatter.applyDefaultFormatting(val);
        }
        if (decimalPlaces == Integer.MAX_VALUE) {
            return Double.toString(val);
        }
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        Map cache = formatters.computeIfAbsent(locale, k -> new ConcurrentHashMap());
        NumberFormat numberFormat = format = cache.computeIfAbsent(decimalPlaces, n -> ValueFormatter.createFormat(locale, decimalPlaces));
        synchronized (numberFormat) {
            return format.format(val);
        }
    }

    private static String applyDefaultFormatting(double val) {
        double absVal = Math.abs(val);
        int dp = absVal > 1000.0 ? 1 : (absVal > 10.0 ? 2 : (absVal > 1.0 ? 3 : 4));
        return GeneralTools.formatNumber((double)val, (int)dp);
    }

    private static NumberFormat createFormat(Locale locale, int nDecimalPlaces) {
        NumberFormat format = NumberFormat.getInstance(locale);
        format.setGroupingUsed(false);
        if (nDecimalPlaces < 0) {
            format.setMaximumFractionDigits(-nDecimalPlaces);
        } else {
            format.setMinimumFractionDigits(nDecimalPlaces);
            format.setMaximumFractionDigits(nDecimalPlaces);
        }
        return format;
    }
}

