/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.interfaces;

import java.util.function.Function;
import qupath.lib.lazy.interfaces.DefaultBooleanLazyValue;
import qupath.lib.lazy.interfaces.DefaultLazyValue;
import qupath.lib.lazy.interfaces.DefaultNumericLazyValue;
import qupath.lib.lazy.interfaces.DefaultStringLazyValue;
import qupath.lib.lazy.interfaces.LazyBooleanValue;
import qupath.lib.lazy.interfaces.LazyNumericValue;
import qupath.lib.lazy.interfaces.LazyStringValue;
import qupath.lib.lazy.interfaces.ValueFormatter;

public interface LazyValue<S, T> {
    public static final int DEFAULT_DECIMAL_PLACES = Integer.MIN_VALUE;

    public static <S, T> LazyValue<S, T> create(String name, String helpText, Function<S, T> fun, Class<T> valueType) {
        return new DefaultLazyValue<S, T>(name, helpText, fun, valueType);
    }

    public static <S> LazyNumericValue<S> createNumeric(String name, String helpText, Function<S, Number> fun) {
        return new DefaultNumericLazyValue<S>(name, helpText, fun);
    }

    public static <S> LazyStringValue<S> createString(String name, String helpText, Function<S, String> fun) {
        return new DefaultStringLazyValue<S>(name, helpText, fun);
    }

    public static <S> LazyBooleanValue<S> createBoolean(String name, String helpText, Function<S, Boolean> fun) {
        return new DefaultBooleanLazyValue<S>(name, helpText, fun);
    }

    public String getName();

    public Class<T> getMeasurementType();

    default public boolean isNumeric() {
        return Number.class.isAssignableFrom(this.getMeasurementType());
    }

    default public boolean isString() {
        return String.class.isAssignableFrom(this.getMeasurementType());
    }

    default public boolean isBoolean() {
        return Boolean.class.isAssignableFrom(this.getMeasurementType());
    }

    public T getValue(S var1);

    default public String getStringValue(S input, int decimalPlaces) {
        T val = this.getValue(input);
        return ValueFormatter.getStringValue(val, decimalPlaces);
    }

    default public String getStringValue(S input) {
        return this.getStringValue(input, Integer.MIN_VALUE);
    }

    public String getHelpText();
}

