/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.lazy.interfaces;

import java.util.function.Function;
import qupath.lib.lazy.interfaces.LazyValue;

class DefaultLazyValue<S, T>
implements LazyValue<S, T> {
    private final String name;
    private final String helpText;
    private final Function<S, T> fun;
    private final Class<T> valueType;

    DefaultLazyValue(String name, String helpText, Function<S, T> fun, Class<T> valueType) {
        this.name = name;
        this.helpText = helpText;
        this.fun = fun;
        this.valueType = valueType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getMeasurementType() {
        return this.valueType;
    }

    @Override
    public T getValue(S input) {
        return this.fun.apply(input);
    }

    @Override
    public String getHelpText() {
        return this.helpText;
    }
}

