/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.experimental.pixels;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import qupath.lib.experimental.pixels.Parameters;
import qupath.lib.images.servers.ColorTransforms;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class PixelProcessorUtils {
    private static final Map<ROI, PreparedGeometry> preparedGeometryCache = Collections.synchronizedMap(new WeakHashMap());

    public static double[] extractMaskedPixels(Parameters<BufferedImage, BufferedImage> params, int channel, Function<PathObject, ROI> roiFunction) throws IOException {
        return PixelProcessorUtils.extractMaskedPixels(params, ColorTransforms.createChannelExtractor((int)channel), roiFunction);
    }

    public static double[] extractMaskedPixels(Parameters<BufferedImage, BufferedImage> params, String channelName, Function<PathObject, ROI> roiFunction) throws IOException {
        return PixelProcessorUtils.extractMaskedPixels(params, ColorTransforms.createChannelExtractor((String)channelName), roiFunction);
    }

    public static double[] extractMaskedPixels(Parameters<BufferedImage, BufferedImage> params, ColorTransforms.ColorTransform transform, Function<PathObject, ROI> roiFunction) throws IOException {
        ROI roi;
        BufferedImage mask;
        ImageServer<BufferedImage> server = params.getServer();
        BufferedImage image = params.getImage();
        PathObject parent = params.getParent();
        byte[] bytes = null;
        if (roiFunction != null && (mask = params.getMask(roi = roiFunction == null ? parent.getROI() : roiFunction.apply(parent))) != null) {
            bytes = ((DataBufferByte)mask.getRaster().getDataBuffer()).getData();
        }
        float[] original = transform.extractChannel(server, image, null);
        double[] pixels = PixelProcessorUtils.convertToDouble(original, bytes);
        return pixels;
    }

    private static double[] convertToDouble(float[] values, byte[] mask) {
        double[] pixels = new double[values.length];
        int ind = 0;
        for (int i = 0; i < values.length; ++i) {
            if (mask != null && mask[i] == 0) continue;
            pixels[ind] = values[i];
            ++ind;
        }
        if (ind < pixels.length) {
            return Arrays.copyOf(pixels, ind);
        }
        return pixels;
    }

    public static List<PathObject> maskObject(ROI parentROI, PathObject child) {
        Geometry childGeom;
        if (parentROI == null) {
            return Collections.singletonList(child);
        }
        if (!PixelProcessorUtils.childOnSamePlane(parentROI, child.getROI()) || parentROI.isEmpty()) {
            return Collections.emptyList();
        }
        PreparedGeometry geom = PixelProcessorUtils.getPreparedGeometry(parentROI);
        Geometry geomOutput = GeometryTools.homogenizeGeometryCollection((Geometry)PixelProcessorUtils.computeIntersection(geom, childGeom = child.getROI().getGeometry()));
        if (geomOutput.isEmpty() || geomOutput.getDimension() < childGeom.getDimension()) {
            return Collections.emptyList();
        }
        if (childGeom.equals(geomOutput)) {
            return Collections.singletonList(child);
        }
        ROI newROI = GeometryTools.geometryToROI((Geometry)geomOutput, (ImagePlane)child.getROI().getImagePlane());
        Object nucleusROI = PathObjectTools.getNucleusROI((PathObject)child);
        if (nucleusROI != null) {
            Geometry nucleusGeom = nucleusROI.getGeometry();
            Geometry nucleusOutput = GeometryTools.homogenizeGeometryCollection((Geometry)PixelProcessorUtils.computeIntersection(geom, nucleusGeom));
            nucleusROI = nucleusOutput.isEmpty() || nucleusOutput.getDimension() < nucleusGeom.getDimension() ? null : GeometryTools.geometryToROI((Geometry)nucleusOutput, (ImagePlane)child.getROI().getImagePlane());
        }
        return Collections.singletonList(PathObjectTools.createLike((PathObject)child, (ROI)newROI, (ROI)nucleusROI));
    }

    public static List<PathObject> maskObjectAndSplit(ROI parentROI, PathObject child) {
        Geometry geomOutput;
        if (!PixelProcessorUtils.childOnSamePlane(parentROI, child.getROI()) || parentROI.isEmpty()) {
            return Collections.emptyList();
        }
        Geometry childGeom = child.getROI().getGeometry();
        if (parentROI != null) {
            PreparedGeometry geom = PixelProcessorUtils.getPreparedGeometry(parentROI);
            geomOutput = GeometryTools.homogenizeGeometryCollection((Geometry)PixelProcessorUtils.computeIntersection(geom, childGeom));
        } else {
            geomOutput = GeometryTools.homogenizeGeometryCollection((Geometry)childGeom);
        }
        if (geomOutput.isEmpty() || geomOutput.getDimension() < childGeom.getDimension()) {
            return Collections.emptyList();
        }
        if (childGeom.equals(geomOutput) && childGeom.getNumGeometries() == 1) {
            return Collections.singletonList(child);
        }
        ROI newROI = GeometryTools.geometryToROI((Geometry)geomOutput, (ImagePlane)child.getROI().getImagePlane());
        return RoiTools.splitROI((ROI)newROI).stream().map(r -> PathObjectTools.createLike((PathObject)child, (ROI)r)).toList();
    }

    private static PreparedGeometry getPreparedGeometry(ROI roi) {
        return preparedGeometryCache.computeIfAbsent(roi, r -> PreparedGeometryFactory.prepare((Geometry)r.getGeometry()));
    }

    private static Geometry computeIntersection(PreparedGeometry parent, Geometry child) {
        if (parent.covers(child)) {
            return child;
        }
        return parent.getGeometry().intersection(child);
    }

    public static boolean containsCentroid(ROI roi, PathObject child) {
        if (roi == null) {
            return false;
        }
        ROI childROI = child.getROI();
        return roi.getImagePlane().equals((Object)childROI.getImagePlane()) && roi.contains(childROI.getCentroidX(), childROI.getCentroidY());
    }

    private static boolean childOnSamePlane(ROI parent, ROI child) {
        if (child == null) {
            return false;
        }
        if (parent == null) {
            return true;
        }
        return parent.getImagePlane().equals((Object)child.getImagePlane());
    }
}

