/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.experimental.pixels;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.SoftReference;
import qupath.lib.experimental.pixels.ImageSupplier;
import qupath.lib.experimental.pixels.MaskSupplier;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.objects.PathObject;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

public class Parameters<S, T> {
    private ImageData<BufferedImage> imageData;
    private ImageServer<BufferedImage> server;
    private TileRequest tile;
    private RegionRequest region;
    private ImageSupplier<S> imageFun;
    private MaskSupplier<S, T> maskFun;
    private transient SoftReference<S> image;
    private PathObject parent;
    private PathObject parentProxy;

    private Parameters(Builder<S, T> builder) {
        this.imageData = builder.imageData;
        this.server = builder.server;
        this.tile = builder.tile;
        this.region = builder.region;
        this.imageFun = builder.imageFun;
        this.maskFun = builder.maskFun;
        this.parent = builder.parent;
        this.parentProxy = builder.parentProxy;
        this.validate();
    }

    private void validate() throws IllegalArgumentException {
        if (this.image == null && (this.imageFun == null || this.getServer() == null)) {
            throw new IllegalArgumentException("Either an image or image function + server must be provided!");
        }
        if (this.getRegionRequest() == null) {
            throw new IllegalArgumentException("Either a region request or tile request must be provided!");
        }
        if (this.parent == null) {
            throw new IllegalArgumentException("A parent object must be provided!");
        }
    }

    public ImageData<BufferedImage> getImageData() {
        return this.imageData;
    }

    public ImageServer<BufferedImage> getServer() {
        return this.server == null ? this.imageData.getServer() : this.server;
    }

    public RegionRequest getRegionRequest() {
        return this.region;
    }

    public TileRequest getTileRequest() {
        return this.tile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S getImage() throws IOException {
        Object img;
        Object t = img = this.image == null ? null : (Object)this.image.get();
        if (img == null) {
            Parameters parameters = this;
            synchronized (parameters) {
                Object t2 = img = this.image == null ? null : (Object)this.image.get();
                if (img == null) {
                    img = this.imageFun.getImage(this);
                    this.image = new SoftReference<Object>(img);
                }
            }
        }
        return (S)img;
    }

    public T getMask() throws IOException {
        PathObject parent = this.getParent();
        return this.getMask(parent == null ? null : parent.getROI());
    }

    public T getMask(ROI roi) throws IOException {
        return this.maskFun == null ? null : (T)this.maskFun.getMask(this, roi);
    }

    public PathObject getParent() {
        return this.parent;
    }

    public PathObject getParentOrProxy() {
        if (this.parentProxy != null) {
            return this.parentProxy;
        }
        return this.parent;
    }

    public static <S, T> Builder<S, T> builder() {
        return new Builder();
    }

    public static class Builder<S, T> {
        private ImageData<BufferedImage> imageData;
        private ImageServer<BufferedImage> server;
        private TileRequest tile;
        private RegionRequest region;
        private ImageSupplier<S> imageFun;
        private MaskSupplier<S, T> maskFun;
        private PathObject parent;
        private PathObject parentProxy;

        public Builder<S, T> imageData(ImageData<BufferedImage> imageData) {
            this.imageData = imageData;
            return this;
        }

        public Builder<S, T> server(ImageServer<BufferedImage> server) {
            this.server = server;
            return this;
        }

        public Builder<S, T> region(RegionRequest region) {
            this.region = region;
            return this;
        }

        public Builder<S, T> tile(TileRequest tile) {
            this.tile = tile;
            return this.region(tile.getRegionRequest());
        }

        public Builder<S, T> imageFunction(ImageSupplier<S> function) {
            this.imageFun = function;
            return this;
        }

        public Builder<S, T> maskFunction(MaskSupplier<S, T> function) {
            this.maskFun = function;
            return this;
        }

        public Builder<S, T> parent(PathObject parent) {
            this.parent = parent;
            return this;
        }

        public Builder<S, T> parentProxy(PathObject parentProxy) {
            this.parentProxy = parentProxy;
            return this;
        }

        public Parameters<S, T> build() {
            return new Parameters(this);
        }
    }
}

