/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.experimental.pixels;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import qupath.lib.experimental.pixels.Parameters;
import qupath.lib.experimental.pixels.PixelProcessorUtils;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

@FunctionalInterface
public interface OutputHandler<S, T, U> {
    public boolean handleOutput(Parameters<S, T> var1, U var2);

    default public OutputHandler<S, T, U> andThen(OutputHandler<S, T, U> after) {
        return (params, output) -> {
            boolean result = this.handleOutput(params, output);
            return after.handleOutput(params, output) || result;
        };
    }

    default public OutputHandler<S, T, U> orElse(OutputHandler<S, T, U> after) {
        return (params, output) -> {
            if (this.handleOutput(params, output)) {
                return true;
            }
            return after.handleOutput(params, output);
        };
    }

    public static <S, T, U> OutputHandler<S, T, U> createUnmaskedObjectOutputHandler(OutputToObjectConverter<S, T, U> converter) {
        return new ObjectOutputHandler(converter, true, ObjectOutputHandler.MaskMode.NONE);
    }

    public static <S, T, U> OutputHandler<S, T, U> createObjectOutputHandler(OutputToObjectConverter<S, T, U> converter) {
        return new ObjectOutputHandler(converter, true, ObjectOutputHandler.MaskMode.MASK_ONLY);
    }

    public static <S, T, U> OutputHandler<S, T, U> createMaskAndSplitObjectOutputHandler(OutputToObjectConverter<S, T, U> converter) {
        return new ObjectOutputHandler(converter, true, ObjectOutputHandler.MaskMode.MASK_AND_SPLIT);
    }

    public static <S, T, U> OutputHandler<S, T, U> consumeOutput() {
        return (params, output) -> true;
    }

    public static boolean handleOutputMeasurements(Parameters<?, ?> params, Map<String, ? extends Number> output) {
        if (output != null) {
            PathObject pathObject = params.getParent();
            try (MeasurementList ml = pathObject.getMeasurementList();){
                for (Map.Entry<String, ? extends Number> entry : output.entrySet()) {
                    String key = entry.getKey();
                    Number value = entry.getValue();
                    if (value == null) {
                        ml.remove(key);
                        continue;
                    }
                    ml.put(key, value.doubleValue());
                }
            }
            return true;
        }
        return false;
    }

    public static boolean handleOutputClassification(Parameters<?, ?> params, PathClass output) {
        PathObject pathObject = params.getParent();
        if (output == null) {
            pathObject.resetPathClass();
        } else {
            pathObject.setPathClass(output);
        }
        return true;
    }

    public static boolean handleOutputClassification(Parameters<?, ?> params, String output) {
        PathObject pathObject = params.getParent();
        if (output == null || output.isEmpty()) {
            pathObject.resetPathClass();
        } else {
            pathObject.setPathClass(PathClass.fromString((String)output));
        }
        return true;
    }

    public static class ObjectOutputHandler<S, T, U>
    implements OutputHandler<S, T, U> {
        private OutputToObjectConverter converter;
        private boolean clearPreviousObjects;
        private MaskMode maskMode;

        private ObjectOutputHandler(OutputToObjectConverter converter, boolean clearPreviousObjects, MaskMode maskMode) {
            this.converter = converter;
            this.clearPreviousObjects = clearPreviousObjects;
            this.maskMode = maskMode;
        }

        @Override
        public boolean handleOutput(Parameters<S, T> params, U output) {
            if (output == null) {
                return false;
            }
            List<Object> newObjects = this.converter.convertToObjects(params, output);
            if (newObjects == null) {
                return false;
            }
            PathObject parentOrProxy = params.getParentOrProxy();
            if (this.clearPreviousObjects) {
                parentOrProxy.clearChildObjects();
            }
            if (!newObjects.isEmpty()) {
                PathObject parent = params.getParent();
                ROI parentROI = ObjectOutputHandler.intersection(parent.getROI(), parentOrProxy.getROI());
                if (parentROI != null) {
                    newObjects = newObjects.stream().flatMap(p -> this.maskOrSplitIfNeeded(parentROI, (PathObject)p)).toList();
                }
                parentOrProxy.addChildObjects(newObjects);
            }
            parentOrProxy.setLocked(true);
            return true;
        }

        private static ROI intersection(ROI roi1, ROI roi2) {
            if (Objects.equals(roi1, roi2)) {
                return roi1;
            }
            if (roi1 == null) {
                return roi2;
            }
            if (roi2 == null) {
                return roi1;
            }
            return RoiTools.intersection((ROI[])new ROI[]{roi1, roi2});
        }

        private Stream<PathObject> maskOrSplitIfNeeded(ROI roi, PathObject pathObject) {
            switch (this.maskMode.ordinal()) {
                case 0: {
                    return Stream.of(pathObject);
                }
                case 1: {
                    return PixelProcessorUtils.maskObject(roi, pathObject).stream();
                }
                case 2: {
                    return PixelProcessorUtils.maskObjectAndSplit(roi, pathObject).stream();
                }
            }
            throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.maskMode));
        }

        static enum MaskMode {
            NONE,
            MASK_ONLY,
            MASK_AND_SPLIT;

        }
    }

    @FunctionalInterface
    public static interface OutputToObjectConverter<S, T, U> {
        public List<PathObject> convertToObjects(Parameters<S, T> var1, U var2);
    }
}

