/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.experimental.pixels;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerScope;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.experimental.pixels.ImageSupplier;
import qupath.lib.experimental.pixels.MaskSupplier;
import qupath.lib.experimental.pixels.OutputHandler;
import qupath.lib.experimental.pixels.Parameters;
import qupath.lib.experimental.pixels.PixelProcessor;
import qupath.lib.experimental.pixels.Processor;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;
import qupath.opencv.tools.OpenCVTools;

public class OpenCVProcessor {
    public static <S, T> OutputHandler<S, T, Mat> createDetectionOutputHandler() {
        return OutputHandler.createObjectOutputHandler(OpenCVProcessor.createDetectionConverter());
    }

    public static <S, T> OutputHandler<S, T, Mat> createDetectionOutputHandler(Map<? extends Number, String> classificationMap) {
        return OutputHandler.createObjectOutputHandler(OpenCVProcessor.createDetectionConverter(classificationMap));
    }

    public static <S, T> OutputHandler<S, T, Mat> createAnnotationOutputHandler() {
        return OutputHandler.createObjectOutputHandler(OpenCVProcessor.createAnnotationConverter());
    }

    public static <S, T> OutputHandler<S, T, Mat> createAnnotationOutputHandler(Map<? extends Number, String> classificationMap) {
        return OutputHandler.createObjectOutputHandler(OpenCVProcessor.createAnnotationConverter(classificationMap));
    }

    public static <S, T> OutputHandler.OutputToObjectConverter<S, T, Mat> createAnnotationConverter() {
        return OpenCVProcessor.createObjectConverter((ROI r) -> PathObjects.createAnnotationObject((ROI)r));
    }

    public static <S, T> OutputHandler.OutputToObjectConverter<S, T, Mat> createAnnotationConverter(Map<? extends Number, String> classificationMap) {
        return OpenCVProcessor.createObjectConverter(r -> PathObjects.createAnnotationObject((ROI)r), classificationMap);
    }

    public static <S, T> OutputHandler.OutputToObjectConverter<S, T, Mat> createDetectionConverter() {
        return OpenCVProcessor.createObjectConverter((ROI r) -> PathObjects.createDetectionObject((ROI)r));
    }

    public static <S, T> OutputHandler.OutputToObjectConverter<S, T, Mat> createDetectionConverter(Map<? extends Number, String> classificationMap) {
        return OpenCVProcessor.createObjectConverter(r -> PathObjects.createDetectionObject((ROI)r), classificationMap);
    }

    public static <S, T> OutputHandler.OutputToObjectConverter<S, T, Mat> createObjectConverter(Function<ROI, PathObject> creator) {
        return OpenCVProcessor.createObjectConverter((ROI r, Number n) -> (PathObject)creator.apply((ROI)r));
    }

    public static <S, T> OutputHandler.OutputToObjectConverter<S, T, Mat> createObjectConverter(Function<ROI, PathObject> creator, Map<? extends Number, String> classificationMap) {
        if (classificationMap == null || classificationMap.isEmpty()) {
            return OpenCVProcessor.createObjectConverter(creator);
        }
        Map<Integer, String> map = classificationMap.entrySet().stream().collect(Collectors.toMap(e -> ((Number)e.getKey()).intValue(), Map.Entry::getValue));
        return OpenCVProcessor.createObjectConverter((ROI r, Number n) -> {
            String name;
            PathObject pathObject = (PathObject)creator.apply((ROI)r);
            if (n != null && (name = (String)map.getOrDefault(n.intValue(), null)) != null && !name.isBlank()) {
                pathObject.setPathClass(PathClass.fromString((String)name));
            }
            return pathObject;
        });
    }

    public static <S, T> OutputHandler.OutputToObjectConverter<S, T, Mat> createObjectConverter(BiFunction<ROI, Number, PathObject> creator) {
        return new OpenCVConverter(creator, true);
    }

    public static PixelProcessor.Builder<Mat, Mat, Mat> builder(Processor<Mat, Mat, Mat> processor) {
        return new PixelProcessor.Builder().imageSupplier(OpenCVProcessor.createMatImageSupplier()).maskSupplier(OpenCVProcessor.createMatMaskSupplier()).outputHandler(OpenCVProcessor.createDetectionOutputHandler()).processor(OpenCVProcessor.wrapInPointerScope(processor));
    }

    public static ImageSupplier<Mat> createMatImageSupplier() {
        return OpenCVProcessor::getImage;
    }

    public static MaskSupplier<Mat, Mat> createMatMaskSupplier() {
        return OpenCVProcessor::getMask;
    }

    private static <S, T> Mat getImage(Parameters<S, T> params) throws IOException {
        return OpenCVTools.imageToMat((BufferedImage)params.getServer().readRegion(params.getRegionRequest()));
    }

    private static Mat getMask(Parameters<Mat, Mat> params, ROI roi) throws IOException {
        Mat image = params.getImage();
        if (roi == null) {
            Mat mat = new Mat(image.rows(), image.cols(), opencv_core.CV_8UC1);
            OpenCVTools.fill(mat, 255.0);
            return mat;
        }
        BufferedImage imgMask = BufferedImageTools.createROIMask((int)image.cols(), (int)image.rows(), (ROI)roi, (RegionRequest)params.getRegionRequest());
        return OpenCVTools.imageToMat(imgMask);
    }

    public static <S, T, U> Processor<S, T, U> wrapInPointerScope(Processor<S, T, U> processor) {
        if (processor instanceof PointerScopeProcessor) {
            return processor;
        }
        return new PointerScopeProcessor<S, T, U>(processor);
    }

    private static class OpenCVConverter<S, T, U>
    implements OutputHandler.OutputToObjectConverter<S, T, U> {
        private static final Logger logger = LoggerFactory.getLogger(OpenCVConverter.class);
        private final boolean releaseOutput;
        private final BiFunction<ROI, Number, PathObject> creator;

        private OpenCVConverter(BiFunction<ROI, Number, PathObject> creator, boolean releaseOutput) {
            this.creator = creator;
            this.releaseOutput = releaseOutput;
        }

        @Override
        public List<PathObject> convertToObjects(Parameters<S, T> params, U output) {
            if (output instanceof Mat) {
                Mat mat = (Mat)output;
                try {
                    PointerScope scope;
                    block13: {
                        List<PathObject> list;
                        scope = new PointerScope();
                        try {
                            if (!OpenCVTools.isFloat(mat)) break block13;
                            logger.warn("Output {} does not have an integer type", (Object)mat);
                            list = Collections.emptyList();
                        }
                        catch (Throwable throwable) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        scope.close();
                        return list;
                    }
                    if (mat.channels() > 1) {
                        logger.debug("Output contains {} channels - only the first channel will be used", (Object)mat.channels());
                        mat = OpenCVTools.splitChannels(mat).get(0);
                    }
                    List<PathObject> list = OpenCVTools.createObjects(mat, params.getRegionRequest(), 1, -1, this.creator).stream().filter(p -> p != null).toList();
                    scope.close();
                    return list;
                }
                finally {
                    if (this.releaseOutput && !mat.isNull()) {
                        mat.release();
                    }
                }
            }
            return null;
        }
    }

    private static class PointerScopeProcessor<S, T, U>
    implements Processor<S, T, U> {
        private final Processor<S, T, U> processor;

        private PointerScopeProcessor(Processor<S, T, U> processor) {
            this.processor = processor;
        }

        @Override
        public U process(Parameters<S, T> params) throws IOException {
            try (PointerScope scope = new PointerScope();){
                U output = this.processor.process(params);
                if (output instanceof Pointer) {
                    Pointer pointer = (Pointer)output;
                    pointer.retainReference();
                }
                U u = output;
                return u;
            }
        }
    }
}

