/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.experimental.pixels;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;
import org.apache.commons.math3.stat.ranking.NaNStrategy;
import qupath.lib.experimental.pixels.ImageSupplier;
import qupath.lib.experimental.pixels.MaskSupplier;
import qupath.lib.experimental.pixels.OutputHandler;
import qupath.lib.experimental.pixels.Parameters;
import qupath.lib.experimental.pixels.PixelProcessor;
import qupath.lib.experimental.pixels.PixelProcessorUtils;
import qupath.lib.experimental.pixels.Processor;
import qupath.lib.images.servers.ColorTransforms;
import qupath.lib.objects.PathObject;
import qupath.lib.roi.interfaces.ROI;

public class MeasurementProcessor {
    public static <S, T> Processor<S, T, Map<String, ? extends Number>> createProcessor(CustomMeasurement<S, T> ... measurement) {
        return new ChannelMeasurementProcessor<S, T>(Arrays.asList(measurement));
    }

    public static <S, T> Processor<S, T, Map<String, ? extends Number>> createProcessor(Collection<? extends CustomMeasurement<S, T>> measurements) {
        return new ChannelMeasurementProcessor(measurements);
    }

    public static PixelProcessor.Builder<BufferedImage, BufferedImage, Map<String, ? extends Number>> builder(Collection<? extends CustomMeasurement<BufferedImage, BufferedImage>> measurements) {
        return new PixelProcessor.Builder().imageSupplier(ImageSupplier.createBufferedImageSupplier()).maskSupplier(MaskSupplier.createBufferedImageMaskSupplier()).processor(MeasurementProcessor.createProcessor(measurements)).outputHandler(OutputHandler::handleOutputMeasurements);
    }

    private static class ChannelMeasurementProcessor<S, T>
    implements Processor<S, T, Map<String, ? extends Number>> {
        private List<CustomMeasurement<S, T>> customMeasurements;

        private ChannelMeasurementProcessor(Collection<? extends CustomMeasurement<S, T>> customMeasurements) {
            this.customMeasurements = new ArrayList<CustomMeasurement<S, T>>(customMeasurements);
        }

        @Override
        public Map<String, ? extends Number> process(Parameters<S, T> params) throws IOException {
            if (this.customMeasurements.isEmpty()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Double> output = new LinkedHashMap<String, Double>();
            for (CustomMeasurement<S, T> m : this.customMeasurements) {
                output.put(m.getName(), m.getValue(params));
            }
            return output;
        }
    }

    public static class Functions {
        public static Function<double[], Double> percentile(double percentile) {
            return values -> Functions.calculatePercentile(values, percentile);
        }

        private static Double calculatePercentile(double[] values, double percentile) {
            Percentile p = new Percentile().withEstimationType(Percentile.EstimationType.R_7).withNaNStrategy(NaNStrategy.REMOVED);
            p.setData(values);
            return p.evaluate(percentile);
        }

        public static Function<double[], Double> min() {
            return values -> Arrays.stream(values).min().orElse(Double.NaN);
        }

        public static Function<double[], Double> max() {
            return values -> Arrays.stream(values).max().orElse(Double.NaN);
        }

        public static Function<double[], Double> mean() {
            return values -> Arrays.stream(values).average().orElse(Double.NaN);
        }

        public static Function<double[][], Double> pearsonsCorrelation() {
            return values -> Functions.calculatePCC(values);
        }

        private static Double calculatePCC(double[][] values) {
            if (values.length != 2) {
                throw new IllegalArgumentException("Only two channels are supported for Pearson's correlation");
            }
            return new PearsonsCorrelation().correlation(values[0], values[1]);
        }

        public static Function<double[][], Double> spearmansCorrelation() {
            return values -> Functions.calculateSpearmans(values);
        }

        private static Double calculateSpearmans(double[][] values) {
            if (values.length != 2) {
                throw new IllegalArgumentException("Only two channels are supported for Spearman's correlation");
            }
            return new SpearmansCorrelation().correlation(values[0], values[1]);
        }
    }

    private static class SingleChannelMeasurement
    implements CustomMeasurement<BufferedImage, BufferedImage> {
        private final ColorTransforms.ColorTransform transform;
        private final String name;
        private final Function<PathObject, ROI> roiFunction;
        private final Function<double[], Double> function;

        private SingleChannelMeasurement(String name, ColorTransforms.ColorTransform transform, Function<double[], Double> function, Function<PathObject, ROI> roiFunction) {
            Objects.requireNonNull(transform, "Transform must not be null");
            Objects.requireNonNull(name, "Name must not be null");
            Objects.requireNonNull(roiFunction, "ROI function must not be null");
            Objects.requireNonNull(function, "Measurement function must not be null");
            this.transform = transform;
            this.name = name;
            this.roiFunction = roiFunction;
            this.function = function;
        }

        public ColorTransforms.ColorTransform getTransform() {
            return this.transform;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public double getValue(Parameters<BufferedImage, BufferedImage> params) throws IOException {
            double[] pixels = PixelProcessorUtils.extractMaskedPixels(params, this.transform, this.roiFunction);
            return this.function.apply(pixels);
        }
    }

    private static class MultiChannelMeasurement
    implements CustomMeasurement<BufferedImage, BufferedImage> {
        private final List<ColorTransforms.ColorTransform> transforms;
        private final String name;
        private final Function<PathObject, ROI> roiFunction;
        private final Function<double[][], Double> function;

        private MultiChannelMeasurement(String name, List<ColorTransforms.ColorTransform> transforms, Function<double[][], Double> function, Function<PathObject, ROI> roiFunction) {
            Objects.requireNonNull(transforms, "Transform must not be null");
            Objects.requireNonNull(name, "Name must not be null");
            Objects.requireNonNull(roiFunction, "ROI function must not be null");
            Objects.requireNonNull(function, "Measurement function must not be null");
            this.transforms = new ArrayList<ColorTransforms.ColorTransform>(transforms);
            this.name = name;
            this.roiFunction = roiFunction;
            this.function = function;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public double getValue(Parameters<BufferedImage, BufferedImage> params) throws IOException {
            double[][] pixels = new double[this.transforms.size()][];
            for (int i = 0; i < this.transforms.size(); ++i) {
                pixels[i] = PixelProcessorUtils.extractMaskedPixels(params, this.transforms.get(i), this.roiFunction);
            }
            return this.function.apply(pixels);
        }
    }

    public static interface CustomMeasurement<S, T> {
        public String getName();

        public double getValue(Parameters<S, T> var1) throws IOException;
    }

    public static class Measurements {
        public static CustomMeasurement<BufferedImage, BufferedImage> multiChannel(String name, List<ColorTransforms.ColorTransform> transforms, Function<double[][], Double> function, Function<PathObject, ROI> roiFunction) {
            return new MultiChannelMeasurement(name, transforms, function, roiFunction);
        }

        public static CustomMeasurement<BufferedImage, BufferedImage> multiChannel(String name, List<ColorTransforms.ColorTransform> transforms, Function<double[][], Double> function) {
            return Measurements.multiChannel(name, transforms, function, PathObject::getROI);
        }

        public static CustomMeasurement<BufferedImage, BufferedImage> singleChannel(String name, ColorTransforms.ColorTransform transform, Function<double[], Double> function, Function<PathObject, ROI> roiFunction) {
            return new SingleChannelMeasurement(name, transform, function, roiFunction);
        }

        public static CustomMeasurement<BufferedImage, BufferedImage> singleChannel(String name, ColorTransforms.ColorTransform transform, Function<double[], Double> function) {
            return Measurements.singleChannel(name, transform, function, PathObject::getROI);
        }
    }
}

