/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.experimental.pixels;

import java.awt.image.BufferedImage;
import java.io.IOException;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.experimental.pixels.Parameters;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

@FunctionalInterface
public interface MaskSupplier<S, T> {
    public T getMask(Parameters<S, T> var1, ROI var2) throws IOException;

    public static MaskSupplier<BufferedImage, BufferedImage> createBufferedImageMaskSupplier() {
        return (parameters, roi) -> {
            BufferedImage image = (BufferedImage)parameters.getImage();
            RegionRequest request = parameters.getRegionRequest();
            return BufferedImageTools.createROIMask((int)image.getWidth(), (int)image.getHeight(), (ROI)roi, (RegionRequest)request);
        };
    }
}

