/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.experimental.pixels;

import ij.ImagePlus;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.BinaryProcessor;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.imagej.processing.IJProcessing;
import qupath.imagej.tools.IJTools;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.experimental.pixels.ImageSupplier;
import qupath.lib.experimental.pixels.MaskSupplier;
import qupath.lib.experimental.pixels.OutputHandler;
import qupath.lib.experimental.pixels.Parameters;
import qupath.lib.experimental.pixels.PixelProcessor;
import qupath.lib.experimental.pixels.Processor;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

public class ImageJProcessor {
    public static ImageSupplier<ImagePlus> createImagePlusImageSupplier() {
        return ImageJProcessor::getImage;
    }

    public static MaskSupplier<ImagePlus, ImagePlus> createImagePlusMaskSupplier() {
        return ImageJProcessor::getMask;
    }

    public static OutputHandler<ImagePlus, ImagePlus, Object> createDetectionOutputHandler() {
        return OutputHandler.createObjectOutputHandler(ImageJProcessor.createDetectionConverter());
    }

    public static OutputHandler<ImagePlus, ImagePlus, Object> createAnnotationOutputHandler() {
        return OutputHandler.createObjectOutputHandler(ImageJProcessor.createAnnotationConverter());
    }

    public static OutputHandler.OutputToObjectConverter<ImagePlus, ImagePlus, Object> createAnnotationConverter() {
        return ImageJProcessor.createObjectConverter(Object.class, PathObjects::createAnnotationObject);
    }

    public static OutputHandler.OutputToObjectConverter<ImagePlus, ImagePlus, Object> createDetectionConverter() {
        return ImageJProcessor.createObjectConverter(Object.class, PathObjects::createDetectionObject);
    }

    public static OutputHandler.OutputToObjectConverter<ImagePlus, ImagePlus, Object> createObjectConverter(Function<ROI, PathObject> creator) {
        return ImageJProcessor.createObjectConverter(Object.class, creator);
    }

    public static <U> OutputHandler.OutputToObjectConverter<ImagePlus, ImagePlus, U> createObjectConverter(Class<U> cls, Function<ROI, PathObject> creator) {
        return new ImageJConverter(cls, creator);
    }

    public static PixelProcessor.Builder<ImagePlus, ImagePlus, Object> builder(Processor<ImagePlus, ImagePlus, Object> processor) {
        return new PixelProcessor.Builder().imageSupplier(ImageJProcessor.createImagePlusImageSupplier()).maskSupplier(ImageJProcessor.createImagePlusMaskSupplier()).outputHandler(ImageJProcessor.createDetectionOutputHandler()).processor(processor);
    }

    private static ImagePlus getImage(Parameters<ImagePlus, ?> params) {
        try {
            ImageServer<BufferedImage> server = params.getServer();
            RegionRequest request = params.getRegionRequest();
            PathObject pathObject = params.getParent();
            PathImage<ImagePlus> pathImage = IJTools.convertToImagePlus(server, request);
            ImagePlus imp = (ImagePlus)pathImage.getImage();
            if (pathObject.hasROI()) {
                imp.setRoi(IJTools.convertToIJRoi(pathObject.getROI(), pathImage));
            }
            return imp;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ImagePlus getMask(Parameters<ImagePlus, ImagePlus> params, ROI roi) throws IOException {
        ImagePlus image = params.getImage();
        RegionRequest request = params.getRegionRequest();
        BufferedImage imgMask = BufferedImageTools.createROIMask((int)image.getWidth(), (int)image.getHeight(), (ROI)roi, (RegionRequest)request);
        ImagePlus impMask = IJTools.convertToUncalibratedImagePlus(image.getTitle() + "-mask", imgMask);
        impMask.setCalibration(image.getCalibration().copy());
        return impMask;
    }

    private static class ImageJConverter<T, U>
    implements OutputHandler.OutputToObjectConverter<ImagePlus, T, U> {
        private static final Logger logger = LoggerFactory.getLogger(ImageJConverter.class);
        private final Class<U> cls;
        private final Function<ROI, PathObject> creator;

        private ImageJConverter(Class<U> cls) {
            this(cls, PathObjects::createDetectionObject);
        }

        private ImageJConverter(Class<U> cls, Function<ROI, PathObject> creator) {
            this.cls = cls;
            this.creator = creator;
        }

        @Override
        public List<PathObject> convertToObjects(Parameters<ImagePlus, T> params, U output) {
            if (this.cls != null && output != null && !this.cls.isInstance(output)) {
                return null;
            }
            if (output instanceof Overlay) {
                Overlay overlay = (Overlay)output;
                return this.handleOverlayOutput(params, overlay);
            }
            if (output instanceof Roi) {
                Roi roi = (Roi)output;
                return this.handleRoiListOutput(params, Collections.singletonList(roi));
            }
            if (output instanceof Roi[]) {
                Roi[] roiArray = (Roi[])output;
                return this.handleRoiListOutput(params, Arrays.asList(roiArray));
            }
            if (output instanceof List) {
                List roiList = (List)output;
                return this.handleRoiListOutput(params, roiList);
            }
            if (output instanceof ImagePlus) {
                ImagePlus imp = (ImagePlus)output;
                return this.handleImagePlusOutput(params, imp);
            }
            if (output instanceof ImageProcessor) {
                ImageProcessor ip = (ImageProcessor)output;
                return this.handleImageProcessorOutput(params, ip);
            }
            return null;
        }

        private List<PathObject> handleOverlayOutput(Parameters<ImagePlus, ?> params, Overlay overlay) {
            if (overlay == null) {
                return Collections.emptyList();
            }
            return this.handleRoiListOutput(params, Arrays.asList(overlay.toArray()));
        }

        private List<PathObject> handleImagePlusOutput(Parameters<ImagePlus, ?> params, ImagePlus output) {
            List<PathObject> results = this.handleImageProcessorOutput(params, output.getProcessor());
            output.close();
            return results;
        }

        private List<PathObject> handleImageProcessorOutput(Parameters<ImagePlus, ?> params, ImageProcessor output) {
            if (output instanceof BinaryProcessor && !output.isThreshold()) {
                output.setBinaryThreshold();
            }
            if (output.isThreshold()) {
                Roi roi = new ThresholdToSelection().convert(output);
                if (roi == null) {
                    return Collections.emptyList();
                }
                return this.handleRoiListOutput(params, Collections.singletonList(roi));
            }
            if (output instanceof ByteProcessor || output instanceof ShortProcessor) {
                List<Roi> rois = IJProcessing.labelsToRois(output);
                return this.handleRoiListOutput(params, rois);
            }
            return Collections.emptyList();
        }

        private List<PathObject> handleRoiListOutput(Parameters<ImagePlus, ?> params, Collection<? extends Roi> output) {
            if (output == null) {
                return null;
            }
            double downsample = params.getRegionRequest().getDownsample();
            try {
                ImagePlus image = params.getImage();
                return output.stream().map(roi -> IJTools.convertToPathObject(roi, downsample, this.creator, image)).toList();
            }
            catch (IOException e) {
                logger.error("Error converting ROI to PathObject", (Throwable)e);
                return Collections.emptyList();
            }
        }
    }
}

