/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.heatmaps;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.heatmaps.DensityMaps;
import qupath.lib.geom.Point2;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.PixelType;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectPredicates;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.Padding;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;
import qupath.opencv.ops.ImageDataOp;
import qupath.opencv.ops.ImageOp;
import qupath.opencv.ops.ImageOps;

class DensityMapDataOp
implements ImageDataOp {
    private static final Logger logger = LoggerFactory.getLogger(DensityMapDataOp.class);
    private DensityMaps.DensityMapType densityType;
    private int radius;
    private Map<String, PathObjectPredicates.PathObjectPredicate> primaryObjects;
    private PathObjectPredicates.PathObjectPredicate allObjects;
    private transient ImageOp op;
    private transient List<ImageChannel> channels;

    public DensityMapDataOp(int radius, Map<String, PathObjectPredicates.PathObjectPredicate> primaryObjects, PathObjectPredicates.PathObjectPredicate allObjects, DensityMaps.DensityMapType densityType) {
        Objects.requireNonNull(densityType);
        if (radius < 0) {
            throw new IllegalArgumentException("Density map radius must be >= 0!");
        }
        this.primaryObjects = new LinkedHashMap<String, PathObjectPredicates.PathObjectPredicate>(primaryObjects);
        this.allObjects = allObjects;
        this.densityType = densityType;
        this.radius = radius;
        this.ensureInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() {
        if (this.op != null) {
            return;
        }
        DensityMapDataOp densityMapDataOp = this;
        synchronized (densityMapDataOp) {
            if (this.op == null) {
                this.buildOpAndChannels();
            }
        }
    }

    private void buildOpAndChannels() {
        String baseChannelName;
        logger.trace("Building density map op with type {}", (Object)this.densityType);
        ImageChannel lastChannel = null;
        ArrayList<ImageOp> sequentialOps = new ArrayList<ImageOp>();
        switch (this.densityType) {
            case GAUSSIAN: {
                if (this.radius > 0) {
                    double sigma = this.radius;
                    sequentialOps.add(ImageOps.Filters.gaussianBlur(sigma));
                    sequentialOps.add(ImageOps.Core.multiply(Math.PI * 2 * sigma * sigma));
                }
                baseChannelName = "Gaussian weighted counts ";
                break;
            }
            case PERCENT: {
                int[] extractInds = IntStream.range(0, this.primaryObjects.size()).toArray();
                if (this.radius > 0) {
                    sequentialOps.add(ImageOps.Filters.sum(this.radius));
                    sequentialOps.add(ImageOps.Core.round());
                }
                if (extractInds.length > 0) {
                    sequentialOps.addAll(Arrays.asList(ImageOps.Core.splitMerge(ImageOps.Core.sequential(ImageOps.Core.splitDivide(ImageOps.Channels.extract(extractInds), ImageOps.Core.sequential(ImageOps.Channels.extract(extractInds.length), ImageOps.Channels.repeat(extractInds.length))), ImageOps.Core.multiply(100.0)), ImageOps.Channels.extract(extractInds.length))));
                } else {
                    sequentialOps.add(ImageOps.Core.splitDivide(null, null));
                }
                baseChannelName = "";
                if (this.primaryObjects.isEmpty()) break;
                lastChannel = ImageChannel.getInstance((String)"Counts", null);
                break;
            }
            default: {
                if (this.radius > 0) {
                    sequentialOps.add(ImageOps.Filters.sum(this.radius));
                    sequentialOps.add(ImageOps.Core.round());
                }
                baseChannelName = "";
            }
        }
        String[] channelNames = (String[])this.primaryObjects.keySet().stream().map(n -> baseChannelName + n).toArray(String[]::new);
        ArrayList<ImageChannel> channels = new ArrayList<ImageChannel>(ImageChannel.getChannelList((String[])channelNames));
        if (lastChannel != null) {
            channels.add(lastChannel);
        }
        this.channels = channels.isEmpty() ? Collections.singletonList(ImageChannel.getInstance((String)"Counts", null)) : Collections.unmodifiableList(channels);
        sequentialOps.add(ImageOps.Core.ensureType(PixelType.FLOAT32));
        this.op = ImageOps.Core.sequential(sequentialOps);
    }

    private int getChannelCount() {
        if (this.primaryObjects.size() == 0) {
            return 1;
        }
        if (this.densityType == DensityMaps.DensityMapType.PERCENT) {
            return this.primaryObjects.size() + 1;
        }
        return this.primaryObjects.size();
    }

    @Override
    public Mat apply(ImageData<BufferedImage> imageData, RegionRequest request) throws IOException {
        List allPathObjects;
        this.ensureInitialized();
        logger.trace("Applying density map op for {}", (Object)request);
        Padding padding = this.op.getPadding();
        if (!padding.isEmpty()) {
            double downsample = request.getDownsample();
            Padding padding2 = Padding.getPadding((int)((int)Math.round((double)padding.getX1() * downsample)), (int)((int)Math.round((double)padding.getX2() * downsample)), (int)((int)Math.round((double)padding.getY1() * downsample)), (int)((int)Math.round((double)padding.getY2() * downsample)));
            request = request.pad2D(padding2);
        }
        if ((allPathObjects = imageData.getHierarchy().getAllObjectsForRegion((ImageRegion)request, null).stream().filter(this.allObjects).toList()).size() == 1) {
            logger.trace("Generating counts tile for 1 object");
        } else {
            logger.trace("Generating counts tile for {} objects", (Object)allPathObjects.size());
        }
        int nChannels = this.getChannelCount();
        int width = (int)Math.round((double)request.getWidth() / request.getDownsample());
        int height = (int)Math.round((double)request.getHeight() / request.getDownsample());
        Mat mat = new Mat(height, width, opencv_core.CV_64FC((int)nChannels), Scalar.ZERO);
        DoubleIndexer idx = (DoubleIndexer)mat.createIndexer();
        int c = 0;
        for (Map.Entry<String, PathObjectPredicates.PathObjectPredicate> entry : this.primaryObjects.entrySet()) {
            PathObjectPredicates.PathObjectPredicate predicate = entry.getValue();
            List<ROI> primaryROIs = allPathObjects.stream().filter(predicate).map(p -> PathObjectTools.getROI((PathObject)p, (boolean)true)).toList();
            List<Point2> points = DensityMapDataOp.objectsToPoints(primaryROIs);
            DensityMapDataOp.incrementCounts(idx, points, request, width, height, c);
            ++c;
        }
        if (c < this.getChannelCount()) {
            List<ROI> allObjectROIs = allPathObjects.stream().map(p -> PathObjectTools.getROI((PathObject)p, (boolean)true)).toList();
            List<Point2> points = DensityMapDataOp.objectsToPoints(allObjectROIs);
            DensityMapDataOp.incrementCounts(idx, points, request, width, height, c);
            ++c;
        }
        idx.close();
        Mat output = this.op.apply(mat);
        return output;
    }

    private static long incrementCounts(DoubleIndexer idx, List<Point2> points, RegionRequest request, int width, int height, int channel) {
        if (points.isEmpty()) {
            return 0L;
        }
        double offsetX = request.getX();
        double offsetY = request.getY();
        double downsample = request.getDownsample();
        long count = 0L;
        for (Point2 p : points) {
            int x = (int)((p.getX() - offsetX) / downsample);
            int y = (int)((p.getY() - offsetY) / downsample);
            if (x < 0 || y < 0 || x >= width || y >= height) continue;
            idx.put((long)y, (long)x, (long)channel, idx.get((long)y, (long)x, (long)channel) + 1.0);
            ++count;
        }
        return count;
    }

    static List<Point2> objectsToPoints(Collection<? extends ROI> roisToPoints) {
        if (roisToPoints.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Point2> points = new ArrayList<Point2>();
        for (ROI rOI : roisToPoints) {
            if (rOI.isPoint()) {
                points.addAll(rOI.getAllPoints());
                continue;
            }
            points.add(new Point2(rOI.getCentroidX(), rOI.getCentroidY()));
        }
        return points;
    }

    @Override
    public boolean supportsImage(ImageData<BufferedImage> imageData) {
        return true;
    }

    @Override
    public List<ImageChannel> getChannels(ImageData<BufferedImage> imageData) {
        return this.getChannels();
    }

    List<ImageChannel> getChannels() {
        this.ensureInitialized();
        return this.channels;
    }

    @Override
    public ImageDataOp appendOps(ImageOp ... ops) {
        if (ops.length == 0) {
            return this;
        }
        ImageOp opNew = ops.length > 1 ? ImageOps.Core.sequential(ops) : ops[0];
        DensityMapDataOp dataOp = new DensityMapDataOp(this.radius, this.primaryObjects, this.allObjects, this.densityType);
        dataOp.op = ImageOps.Core.sequential(dataOp.op, opNew);
        dataOp.channels = opNew.getChannels(dataOp.channels);
        return dataOp;
    }

    @Override
    public PixelType getOutputType(PixelType inputType) {
        return PixelType.FLOAT32;
    }

    public Collection<URI> getURIs() throws IOException {
        return this.op == null ? Collections.emptyList() : this.op.getURIs();
    }

    public boolean updateURIs(Map<URI, URI> replacements) throws IOException {
        if (this.op == null) {
            return false;
        }
        return this.op.updateURIs(replacements);
    }

    static {
        ImageOps.registerDataOp(DensityMapDataOp.class, "data.op.density");
    }
}

