/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.features;

import java.util.Arrays;
import java.util.HashSet;
import qupath.lib.analysis.images.SimpleImage;

public class LocalBinaryPatterns {
    private static int[] lbf8map;
    private static int nLBF8;
    private static int[] lbf8UniformMap;
    private static int nLBF8Uniform;
    private static int[] lbf16UniformMap;
    private static int nLBF16Uniform;
    private static double[] xo8;
    private static double[] yo8;
    private static double[] xo16;
    private static double[] yo16;

    private static void tidyDoubleUnitArray(double[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            double d = arr[i];
            if (Math.abs(d) < 1.0E-5) {
                arr[i] = 0.0;
                continue;
            }
            double signum = Math.signum(d);
            if (!(Math.abs(d - signum) < 1.0E-5)) continue;
            arr[i] = signum;
        }
    }

    private static int computeLocalBinaryPattern(SimpleImage img, int x, int y) {
        float val = img.getValue(x, y);
        if (Float.isNaN(val)) {
            return -1;
        }
        int lbp = 0;
        if (img.getValue(x - 1, y - 1) >= val) {
            lbp = (byte)(lbp | 0xFFFFFF80);
        }
        if (img.getValue(x, y - 1) >= val) {
            lbp = (byte)(lbp | 0x40);
        }
        if (img.getValue(x + 1, y - 1) >= val) {
            lbp = (byte)(lbp | 0x20);
        }
        if (img.getValue(x - 1, y) >= val) {
            lbp = (byte)(lbp | 0x10);
        }
        if (img.getValue(x + 1, y) >= val) {
            lbp = (byte)(lbp | 8);
        }
        if (img.getValue(x - 1, y + 1) >= val) {
            lbp = (byte)(lbp | 4);
        }
        if (img.getValue(x, y + 1) >= val) {
            lbp = (byte)(lbp | 2);
        }
        if (img.getValue(x + 1, y + 1) >= val) {
            lbp = (byte)(lbp | 1);
        }
        int pattern = lbp & 0xFF;
        return lbf8UniformMap[pattern];
    }

    private static int computeLocalBinaryPattern16(SimpleImage img, int x, int y, double radius) {
        float val = img.getValue(x, y);
        if (Float.isNaN(val)) {
            return -1;
        }
        int lbp = 0;
        for (int i = 0; i < 16; ++i) {
            if (!(LocalBinaryPatterns.getInterpolatedPixel(img, (double)x + xo16[i] * radius, (double)y + yo16[i] * radius) >= val)) continue;
            lbp = (short)(lbp | (short)(1 << i));
        }
        int pattern = lbp & 0xFFFF;
        return lbf16UniformMap[pattern];
    }

    private static float getInterpolatedPixel(SimpleImage img, double x, double y) {
        int fx = (int)x;
        int fy = (int)y;
        int cx = fx + 1;
        int cy = fy + 1;
        double ty = y - (double)fy;
        double tx = x - (double)fx;
        double w1 = (1.0 - tx) * (1.0 - ty);
        double w2 = tx * (1.0 - ty);
        double w3 = (1.0 - tx) * ty;
        double w4 = tx * ty;
        float value = 0.0f;
        if (w1 > 0.0) {
            value = (float)((double)value + w1 * (double)img.getValue(fx, fy));
        }
        if (w2 > 0.0) {
            value = (float)((double)value + w2 * (double)img.getValue(cx, fy));
        }
        if (w3 > 0.0) {
            value = (float)((double)value + w3 * (double)img.getValue(fx, cy));
        }
        if (w4 > 0.0) {
            value = (float)((double)value + w4 * (double)img.getValue(cx, cy));
        }
        return value;
    }

    private static double[] computeLocalBinaryPatterns(SimpleImage img, int x1, int y1, int x2, int y2) {
        double[] hist = new double[nLBF8Uniform];
        int n = 0;
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                int v = LocalBinaryPatterns.computeLocalBinaryPattern(img, x, y);
                if (v < 0) continue;
                int n2 = v;
                hist[n2] = hist[n2] + 1.0;
                ++n;
            }
        }
        int i = 0;
        while (i < hist.length) {
            int n3 = i++;
            hist[n3] = hist[n3] / (double)n;
        }
        return hist;
    }

    private static double[] computeLocalBinaryPatterns16(SimpleImage img, int x1, int y1, int x2, int y2, double radius) {
        double[] hist = new double[nLBF16Uniform];
        int n = 0;
        for (int y = y1; y < y2; ++y) {
            for (int x = x1; x < x2; ++x) {
                int v = LocalBinaryPatterns.computeLocalBinaryPattern16(img, x, y, radius);
                if (v < 0) continue;
                int n2 = v;
                hist[n2] = hist[n2] + 1.0;
                ++n;
            }
        }
        int i = 0;
        while (i < hist.length) {
            int n3 = i++;
            hist[n3] = hist[n3] / (double)n;
        }
        return hist;
    }

    public static double[] computeLocalBinaryPatterns16(SimpleImage img, double radius) {
        int r2 = (int)Math.ceil(radius);
        return LocalBinaryPatterns.computeLocalBinaryPatterns16(img, r2, r2, img.getWidth() - r2, img.getHeight() - r2, radius);
    }

    private static double[] computeLocalBinaryPatterns(SimpleImage img) {
        return LocalBinaryPatterns.computeLocalBinaryPatterns(img, 1, 1, img.getWidth() - 1, img.getHeight() - 1);
    }

    static {
        int i;
        int pattern2;
        int i2;
        int uniformCount;
        lbf8map = new int[256];
        lbf8UniformMap = new int[256];
        lbf16UniformMap = new int[65536];
        xo8 = new double[8];
        yo8 = new double[8];
        xo16 = new double[16];
        yo16 = new double[16];
        HashSet<Integer> patternSet = new HashSet<Integer>();
        for (int k = 0; k < 256; ++k) {
            byte lbp = (byte)k;
            int pattern = k;
            for (int i3 = 1; i3 < 8; ++i3) {
                pattern = Math.min(pattern, ((lbp & 0xFF) >>> i3 | lbp << 8 - i3) & 0xFF);
            }
            patternSet.add(pattern);
        }
        int count = 0;
        int countUniform = 0;
        Arrays.fill(lbf8UniformMap, 9);
        for (Integer pattern : patternSet) {
            LocalBinaryPatterns.lbf8map[pattern.intValue()] = count++;
            uniformCount = (pattern ^ (pattern >>> 1 | pattern << 7)) & 0xFF;
            if (Integer.bitCount(uniformCount) > 2) continue;
            LocalBinaryPatterns.lbf8UniformMap[pattern.intValue()] = countUniform;
            for (i2 = 1; i2 < 8; ++i2) {
                pattern2 = (pattern >>> i2 | pattern << 8 - i2) & 0xFF;
                LocalBinaryPatterns.lbf8UniformMap[pattern2] = countUniform;
            }
            ++countUniform;
        }
        nLBF8 = count;
        nLBF8Uniform = 10;
        patternSet.clear();
        for (int k = 0; k < 65536; ++k) {
            short lbp = (short)k;
            int pattern = k;
            for (i2 = 1; i2 < 16; ++i2) {
                pattern = Math.min(pattern, ((lbp & 0xFFFF) >>> i2 | lbp << 16 - i2) & 0xFFFF);
            }
            patternSet.add(pattern);
        }
        countUniform = 0;
        Arrays.fill(lbf16UniformMap, 17);
        for (Integer pattern : patternSet) {
            uniformCount = (pattern ^ (pattern >>> 1 | pattern << 15)) & 0xFFFF;
            if (Integer.bitCount(uniformCount) > 2) continue;
            LocalBinaryPatterns.lbf16UniformMap[pattern.intValue()] = countUniform;
            for (i2 = 1; i2 < 16; ++i2) {
                pattern2 = (pattern >>> i2 | pattern << 16 - i2) & 0xFFFF;
                LocalBinaryPatterns.lbf16UniformMap[pattern2] = countUniform;
            }
            ++countUniform;
        }
        nLBF16Uniform = countUniform + 1;
        double scale = 0.7853981633974483;
        for (i = 0; i < 8; ++i) {
            LocalBinaryPatterns.xo8[i] = Math.cos(scale * (double)i);
            LocalBinaryPatterns.yo8[i] = -Math.sin(scale * (double)i);
        }
        LocalBinaryPatterns.tidyDoubleUnitArray(xo8);
        LocalBinaryPatterns.tidyDoubleUnitArray(yo8);
        scale = 0.39269908169872414;
        for (i = 0; i < 16; ++i) {
            LocalBinaryPatterns.xo16[i] = Math.cos(scale * (double)i);
            LocalBinaryPatterns.yo16[i] = -Math.sin(scale * (double)i);
        }
        LocalBinaryPatterns.tidyDoubleUnitArray(xo16);
        LocalBinaryPatterns.tidyDoubleUnitArray(yo16);
    }
}

