/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.features;

import qupath.lib.analysis.features.CoocMatrix;
import qupath.lib.analysis.stats.RunningStatistics;

public class HaralickFeatures {
    private static final double LOG2 = Math.log(2.0);
    private CoocMatrix matrix;
    private double[] f = new double[13];
    private static final String[] FEATURE_NAMES = new String[]{"Angular second moment", "Contrast", "Correlation", "Sum of squares", "Inverse difference moment", "Sum average", "Sum variance", "Sum entropy", "Entropy", "Difference variance", "Difference entropy", "Information measure of correlation 1", "Information measure of correlation 2"};

    HaralickFeatures(CoocMatrix matrix) {
        this.matrix = matrix;
        this.computeFeatures();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (double d : this.f) {
            sb.append(d + ", ");
        }
        return sb.toString();
    }

    private static RunningStatistics getStatistics(double[] array) {
        RunningStatistics stats = new RunningStatistics();
        for (double d : array) {
            stats.addValue(d);
        }
        return stats;
    }

    private void computeFeatures() {
        if (this.matrix == null) {
            return;
        }
        this.matrix.finalizeMatrix();
        int n = this.matrix.getN();
        double[] px = new double[n];
        double[] py = new double[n];
        double[] px_and_y = new double[2 * n + 1];
        double[] px_y = new double[n];
        double mx = 0.0;
        double my = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double val = this.matrix.get(i, j);
                int n2 = i;
                px[n2] = px[n2] + val;
                int n3 = j;
                py[n3] = py[n3] + val;
                int n4 = i + j;
                px_and_y[n4] = px_and_y[n4] + val;
                int n5 = Math.abs(i - j);
                px_y[n5] = px_y[n5] + val;
                mx += (double)(i + 1) * val;
                my += (double)(j + 1) * val;
            }
        }
        double sx = 0.0;
        double sy = 0.0;
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= n; ++j) {
                double val = this.matrix.get(i - 1, j - 1);
                sx += ((double)i - mx) * ((double)i - mx) * val;
                sy += ((double)j - my) * ((double)j - my) * val;
            }
        }
        sx = Math.sqrt(sx);
        sy = Math.sqrt(sy);
        double f1 = 0.0;
        double f3 = 0.0;
        double f5 = 0.0;
        double f9 = 0.0;
        double Hxy1 = 0.0;
        double Hxy2 = 0.0;
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= n; ++j) {
                double val = this.matrix.get(i - 1, j - 1);
                double logVal = this.matrix.getLog(i - 1, j - 1) / LOG2;
                f1 += val * val;
                f3 += (double)(i * j) * val;
                f5 += val / (double)(1 + (i - j) * (i - j));
                f9 -= val * logVal;
                double temp = px[i - 1] * py[j - 1];
                if (temp == 0.0) continue;
                double logTemp = Math.log(temp) / LOG2;
                Hxy1 -= val * logTemp;
                Hxy2 -= temp * logTemp;
            }
        }
        double Hxy = f9;
        f3 -= mx * my;
        f3 /= sx * sy;
        double f4 = sx * sx;
        double f2 = 0.0;
        for (int nn = 0; nn < n; ++nn) {
            f2 += (double)(nn * nn) * px_y[nn];
        }
        double f6 = 0.0;
        double f8 = 0.0;
        for (int i = 2; i <= 2 * n; ++i) {
            double val = px_and_y[i];
            if (val == 0.0) continue;
            f6 += (double)i * val;
            f8 -= val * (Math.log(val) / LOG2);
        }
        double f7 = 0.0;
        for (int i = 2; i <= 2 * n; ++i) {
            f7 += ((double)i - f6) * ((double)i - f6) * px_and_y[i];
        }
        double f11 = 0.0;
        for (int i = 0; i < n; ++i) {
            double val = px_y[i];
            if (val == 0.0) continue;
            f11 -= val * (Math.log(val) / LOG2);
        }
        RunningStatistics px_yStats = HaralickFeatures.getStatistics(px_y);
        double f10 = px_yStats.getVariance();
        double Hx = 0.0;
        double Hy = 0.0;
        for (int i = 0; i < n; ++i) {
            double val = px[i];
            if (val != 0.0) {
                Hx -= val * Math.log(val) / LOG2;
            }
            if ((val = py[i]) == 0.0) continue;
            Hy -= val * Math.log(val) / LOG2;
        }
        double f12 = (Hxy - Hxy1) / Math.max(Hx, Hy);
        double f13 = Math.sqrt(1.0 - Math.exp(-2.0 * (Hxy2 - Hxy)));
        this.f[0] = f1;
        this.f[1] = f2;
        this.f[2] = f3;
        this.f[3] = f4;
        this.f[4] = f5;
        this.f[5] = f6;
        this.f[6] = f7;
        this.f[7] = f8;
        this.f[8] = f9;
        this.f[9] = f10;
        this.f[10] = f11;
        this.f[11] = f12;
        this.f[12] = f13;
    }

    private void computeFeaturesJ() {
        if (this.matrix == null) {
            return;
        }
        this.matrix.finalizeMatrix();
        int n = this.matrix.getN();
        double[] px = new double[n];
        double[] py = new double[n];
        double[] px_and_y = new double[2 * n + 1];
        double[] px_y = new double[n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double val = this.matrix.get(i, j);
                int n2 = i;
                px[n2] = px[n2] + val;
                int n3 = j;
                py[n3] = py[n3] + val;
                int n4 = i + j;
                px_and_y[n4] = px_and_y[n4] + val;
                int n5 = Math.abs(i - j);
                px_y[n5] = px_y[n5] + val;
            }
        }
        double mx = 0.0;
        double my = 0.0;
        for (int i = 0; i < n; ++i) {
            mx += px[i];
            my += py[i];
        }
        mx /= (double)n;
        my /= (double)n;
        double sx = 0.0;
        double sy = 0.0;
        for (int i = 0; i < n; ++i) {
            sx += (px[i] - mx) * (px[i] - mx);
            sy += (py[i] - my) * (py[i] - my);
        }
        sx = Math.sqrt(sx / (double)(n - 1));
        sy = Math.sqrt(sy / (double)(n - 1));
        double f1 = 0.0;
        double f3 = 0.0;
        double f5 = 0.0;
        double f9 = 0.0;
        double Hxy1 = 0.0;
        double Hxy2 = 0.0;
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= n; ++j) {
                double val = this.matrix.get(i - 1, j - 1);
                double logVal = this.matrix.getLog(i - 1, j - 1) / LOG2;
                f1 += val * val;
                f3 += (double)(i * j) * val;
                f5 += val / (double)(1 + (i - j) * (i - j));
                f9 -= val * logVal;
                double temp = px[i - 1] * py[j - 1];
                if (temp == 0.0) continue;
                double logTemp = Math.log(temp) / LOG2;
                Hxy1 -= val * logTemp;
                Hxy2 -= temp * logTemp;
            }
        }
        double Hxy = f9;
        f3 -= mx * my;
        f3 /= sx * sy;
        double f4 = sx * sx;
        double f2 = 0.0;
        for (int nn = 0; nn < n; ++nn) {
            f2 += (double)(nn * nn) * px_y[nn];
        }
        double f6 = 0.0;
        double f8 = 0.0;
        for (int i = 2; i <= 2 * n; ++i) {
            double val = px_and_y[i];
            if (val == 0.0) continue;
            f6 += (double)i * val;
            f8 -= val * (Math.log(val) / LOG2);
        }
        double f7 = 0.0;
        for (int i = 2; i <= 2 * n; ++i) {
            f7 += ((double)i - f6) * ((double)i - f6) * px_and_y[i];
        }
        double f11 = 0.0;
        for (int i = 0; i < n; ++i) {
            double val = px_y[i];
            if (val == 0.0) continue;
            f11 -= val * (Math.log(val) / LOG2);
        }
        RunningStatistics px_yStats = HaralickFeatures.getStatistics(px_y);
        double f10 = px_yStats.getVariance();
        double Hx = 0.0;
        double Hy = 0.0;
        for (int i = 0; i < n; ++i) {
            double val = px[i];
            if (val != 0.0) {
                Hx -= val * Math.log(val) / LOG2;
            }
            if ((val = py[i]) == 0.0) continue;
            Hy -= val * Math.log(val) / LOG2;
        }
        double f12 = (Hxy - Hxy1) / Math.max(Hx, Hy);
        double f13 = Math.sqrt(1.0 - Math.exp(-2.0 * (Hxy2 - Hxy)));
        this.f[0] = f1;
        this.f[1] = f2;
        this.f[2] = f3;
        this.f[3] = f4;
        this.f[4] = f5;
        this.f[5] = f6;
        this.f[6] = f7;
        this.f[7] = f8;
        this.f[8] = f9;
        this.f[9] = f10;
        this.f[10] = f11;
        this.f[11] = f12;
        this.f[12] = f13;
    }

    public String getFeatureName(int n) {
        return FEATURE_NAMES[n];
    }

    public int nFeatures() {
        return 13;
    }

    public double getFeature(int n) {
        return this.f[n];
    }

    double[] features() {
        return this.f;
    }
}

