/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.features;

import qupath.lib.analysis.features.CoocurranceMatrices;
import qupath.lib.analysis.features.HaralickFeatures;
import qupath.lib.analysis.images.SimpleImage;
import qupath.lib.analysis.stats.RunningStatistics;

public class HaralickFeatureComputer {
    public static HaralickFeatures measureHaralick(SimpleImage ip, SimpleImage bpMask, int nBins, double minValue, double maxValue, int d) {
        return HaralickFeatureComputer.measureHaralick(ip, bpMask, 0, 0, ip.getWidth(), ip.getHeight(), nBins, minValue, maxValue, d);
    }

    private static HaralickFeatures measureHaralick(SimpleImage ip, SimpleImage bpMask, int xx, int yy, int ww, int hh, int nBins, double minValue, double maxValue, int d) {
        if (Double.isNaN(minValue) || Double.isNaN(maxValue)) {
            RunningStatistics stats = HaralickFeatureComputer.getStatistics(ip);
            minValue = stats.getMin();
            maxValue = stats.getMax();
        }
        CoocurranceMatrices matrices = HaralickFeatureComputer.updateCooccurrenceMatrices(null, ip, bpMask, xx, yy, ww, hh, nBins, minValue, maxValue, d);
        HaralickFeatures features = matrices.getMeanFeatures();
        return features;
    }

    public static CoocurranceMatrices updateCooccurrenceMatrices(CoocurranceMatrices matrices, SimpleImage ip, SimpleImage bpMask, int nBins, double minValue, double maxValue, int d) {
        return HaralickFeatureComputer.updateCooccurrenceMatrices(matrices, ip, bpMask, 0, 0, ip.getWidth(), ip.getHeight(), nBins, minValue, maxValue, d);
    }

    private static CoocurranceMatrices updateCooccurrenceMatrices(CoocurranceMatrices matrices, SimpleImage ip, SimpleImage bpMask, int xx, int yy, int ww, int hh, int nBins, double minValue, double maxValue, int d) {
        if (matrices == null) {
            matrices = new CoocurranceMatrices(nBins);
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        double binDepth = (maxValue - minValue) / (double)nBins;
        boolean noMask = bpMask == null;
        for (int y = yy; y < yy + hh; ++y) {
            for (int x = xx; x < xx + ww; ++x) {
                int binValue;
                if (!noMask && bpMask.getValue(x, y) == 0.0f || (binValue = HaralickFeatureComputer.getBinValue(ip, x, y, minValue, binDepth, nBins)) < 0) continue;
                if (x < width - d && (noMask || bpMask.getValue(x + d, y) != 0.0f)) {
                    matrices.put0(binValue, HaralickFeatureComputer.getBinValue(ip, x + d, y, minValue, binDepth, nBins));
                }
                if (y < height - d && (noMask || bpMask.getValue(x, y + d) != 0.0f)) {
                    matrices.put90(binValue, HaralickFeatureComputer.getBinValue(ip, x, y + d, minValue, binDepth, nBins));
                }
                if (x < width - d && y < height - d && (noMask || bpMask.getValue(x + d, y + d) != 0.0f)) {
                    matrices.put45(binValue, HaralickFeatureComputer.getBinValue(ip, x + d, y + d, minValue, binDepth, nBins));
                }
                if (x < d || y >= height - d || !noMask && bpMask.getValue(x - d, y + d) == 0.0f) continue;
                matrices.put135(binValue, HaralickFeatureComputer.getBinValue(ip, x - d, y + d, minValue, binDepth, nBins));
            }
        }
        return matrices;
    }

    private static int getBinValue(SimpleImage ip, int x, int y, double minValue, double binDepth, int nBins) {
        float val = ip.getValue(x, y);
        if (Float.isNaN(val)) {
            return -1;
        }
        int ind = (int)(((double)val - minValue) / binDepth);
        if (ind < 0) {
            return 0;
        }
        if (ind >= nBins) {
            return nBins - 1;
        }
        return ind;
    }

    private static RunningStatistics getStatistics(SimpleImage img) {
        RunningStatistics stats = new RunningStatistics();
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                stats.addValue((double)img.getValue(x, y));
            }
        }
        return stats;
    }
}

