/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.features;

import java.util.Arrays;
import qupath.lib.analysis.features.CoocMatrix;
import qupath.lib.analysis.features.HaralickFeatures;

public class CoocurranceMatrices {
    private CoocMatrix mat0;
    private CoocMatrix mat45;
    private CoocMatrix mat90;
    private CoocMatrix mat135;
    private HaralickFeatures[] features = null;

    public CoocurranceMatrices(int n) {
        this.mat0 = new CoocMatrix(n);
        this.mat45 = new CoocMatrix(n);
        this.mat90 = new CoocMatrix(n);
        this.mat135 = new CoocMatrix(n);
    }

    public void put0(int i, int j) {
        if (i >= 0 && j >= 0) {
            this.mat0.addToEntrySymmetric(i, j);
        }
    }

    public void put45(int i, int j) {
        if (i >= 0 && j >= 0) {
            this.mat45.addToEntrySymmetric(i, j);
        }
    }

    public void put90(int i, int j) {
        if (i >= 0 && j >= 0) {
            this.mat90.addToEntrySymmetric(i, j);
        }
    }

    public void put135(int i, int j) {
        if (i >= 0 && j >= 0) {
            this.mat135.addToEntrySymmetric(i, j);
        }
    }

    public void computeFeatures() {
        this.features = new HaralickFeatures[4];
        this.features[0] = new HaralickFeatures(this.mat0);
        this.features[1] = new HaralickFeatures(this.mat45);
        this.features[2] = new HaralickFeatures(this.mat90);
        this.features[3] = new HaralickFeatures(this.mat135);
    }

    public HaralickFeatures getMeanFeatures() {
        if (this.features == null) {
            this.computeFeatures();
        }
        HaralickFeatures featuresMean = new HaralickFeatures(null);
        double[] featuresMeanArray = featuresMean.features();
        for (int i = 0; i < this.features.length; ++i) {
            double[] featuresTemp = this.features[i].features();
            int ind = 0;
            for (double val : featuresTemp) {
                int n = ind++;
                featuresMeanArray[n] = featuresMeanArray[n] + val / 4.0;
            }
        }
        return featuresMean;
    }

    public HaralickFeatures getMinFeatures() {
        if (this.features == null) {
            this.computeFeatures();
        }
        HaralickFeatures featuresMin = new HaralickFeatures(null);
        double[] featuresMinArray = featuresMin.features();
        Arrays.fill(featuresMinArray, Double.NaN);
        for (int i = 0; i < this.features.length; ++i) {
            double[] featuresTemp = this.features[i].features();
            int ind = 0;
            for (double val : featuresTemp) {
                if (!(featuresMinArray[ind] < val)) {
                    featuresMinArray[ind] = val;
                }
                ++ind;
            }
        }
        return featuresMin;
    }

    public HaralickFeatures getMaxFeatures() {
        if (this.features == null) {
            this.computeFeatures();
        }
        HaralickFeatures featuresMax = new HaralickFeatures(null);
        double[] featuresMaxArray = featuresMax.features();
        Arrays.fill(featuresMaxArray, Double.NaN);
        for (int i = 0; i < this.features.length; ++i) {
            double[] featuresTemp = this.features[i].features();
            int ind = 0;
            for (double val : featuresTemp) {
                if (!(featuresMaxArray[ind] > val)) {
                    featuresMaxArray[ind] = val;
                }
                ++ind;
            }
        }
        return featuresMax;
    }
}

