/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.features;

class CoocMatrix {
    private int[] mat;
    private int n;
    private int sum = 0;
    private double logSum = 0.0;
    private static double[] logTable = new double[65536];

    public CoocMatrix(int n) {
        this.n = n;
        this.mat = new int[n * n];
    }

    public int getN() {
        return this.n;
    }

    public void addToEntrySymmetric(int row, int col) {
        this.addToEntry(row, col);
        this.addToEntry(col, row);
    }

    public void addToEntry(int row, int col) {
        int n = row * this.n + col;
        this.mat[n] = this.mat[n] + 1;
        ++this.sum;
    }

    public void finalizeMatrix() {
        this.logSum = Math.log(this.sum);
    }

    public double get(int row, int col) {
        return (double)this.mat[row * this.n + col] / (double)this.sum;
    }

    public int getRawCounts(int row, int col) {
        return this.mat[row * this.n + col];
    }

    public double getLog(int row, int col) {
        int ind = this.mat[row * this.n + col];
        if (ind < logTable.length) {
            return logTable[ind] - this.logSum;
        }
        return Math.log(ind) - this.logSum;
    }

    public double getMean() {
        return (double)this.sum / (double)(this.n * this.n);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                sb.append(this.getRawCounts(i, j));
                if (j >= this.n - 1) continue;
                sb.append(", ");
            }
            if (i >= this.n - 1) continue;
            sb.append("\n");
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        for (int i = 1; i < logTable.length; ++i) {
            CoocMatrix.logTable[i] = Math.log(i);
        }
    }
}

