/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.algorithms;

import java.util.PriorityQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.images.SimpleImage;
import qupath.lib.analysis.images.SimpleModifiableImage;

public class Watershed {
    private static final Logger logger = LoggerFactory.getLogger(Watershed.class);

    public static void doWatershed(SimpleImage ip, SimpleModifiableImage ipLabels, boolean conn8) {
        Watershed.doWatershed(ip, ipLabels, Double.NEGATIVE_INFINITY, conn8);
    }

    public static void doWatershed(SimpleImage ip, SimpleModifiableImage ipLabels, double minThreshold, boolean conn8) {
        long startTime = System.currentTimeMillis();
        int width = ip.getWidth();
        int height = ip.getHeight();
        WatershedQueueWrapper queue = new WatershedQueueWrapper(ip, (SimpleImage)ipLabels, minThreshold);
        while (!queue.isEmpty()) {
            PixelWithValue pwv = queue.poll();
            float lastLabel = conn8 ? Watershed.getNeighborLabels8((SimpleImage)ipLabels, pwv.x, pwv.y, width, height) : Watershed.getNeighborLabels4((SimpleImage)ipLabels, pwv.x, pwv.y, width, height);
            if (Float.isNaN(lastLabel)) continue;
            ipLabels.setValue(pwv.x, pwv.y, lastLabel);
            if (conn8) {
                Watershed.addNeighboursToQueue8(queue, pwv.x, pwv.y, width, height);
                continue;
            }
            Watershed.addNeighboursToQueue4(queue, pwv.x, pwv.y, width, height);
        }
        long endTime = System.currentTimeMillis();
        logger.trace(String.format("Watershed time taken: %.2fs", (double)(endTime - startTime) / 1000.0));
    }

    private static float getNeighborLabels4(SimpleImage ipLabels, int x, int y, int w, int h) {
        float label;
        float lastLabel = Float.NaN;
        if (x > 0 && (label = ipLabels.getValue(x - 1, y)) != 0.0f) {
            lastLabel = label;
        }
        if (x < w - 1 && (label = ipLabels.getValue(x + 1, y)) != 0.0f) {
            if (Float.isNaN(lastLabel)) {
                lastLabel = label;
            } else if (lastLabel != label) {
                return Float.NaN;
            }
        }
        if (y > 0 && (label = ipLabels.getValue(x, y - 1)) != 0.0f) {
            if (Float.isNaN(lastLabel)) {
                lastLabel = label;
            } else if (lastLabel != label) {
                return Float.NaN;
            }
        }
        if (y < h - 1 && (label = ipLabels.getValue(x, y + 1)) != 0.0f) {
            if (Float.isNaN(lastLabel)) {
                lastLabel = label;
            } else if (lastLabel != label) {
                return Float.NaN;
            }
        }
        return lastLabel;
    }

    private static void addNeighboursToQueue4(WatershedQueueWrapper queue, int x, int y, int w, int h) {
        queue.add(x, y - 1);
        queue.add(x - 1, y);
        queue.add(x + 1, y);
        queue.add(x, y + 1);
    }

    private static float getNeighborLabels8(SimpleImage ipLabels, int x, int y, int w, int h) {
        float lastLabel = Float.NaN;
        for (int yy = Math.max(y - 1, 0); yy <= Math.min(h - 1, y + 1); ++yy) {
            for (int xx = Math.max(x - 1, 0); xx <= Math.min(w - 1, x + 1); ++xx) {
                float label;
                if (xx == x && yy == y || (label = ipLabels.getValue(xx, yy)) <= 0.0f) continue;
                if (Float.isNaN(lastLabel)) {
                    lastLabel = label;
                    continue;
                }
                if (lastLabel == label) continue;
                return Float.NaN;
            }
        }
        return lastLabel;
    }

    private static void addNeighboursToQueue8(WatershedQueueWrapper queue, int x, int y, int w, int h) {
        queue.add(x - 1, y - 1);
        queue.add(x, y - 1);
        queue.add(x + 1, y - 1);
        queue.add(x - 1, y);
        queue.add(x + 1, y);
        queue.add(x - 1, y + 1);
        queue.add(x, y + 1);
        queue.add(x + 1, y + 1);
    }

    private static final class WatershedQueueWrapper {
        private PriorityQueue<PixelWithValue> queue = new PriorityQueue();
        private boolean[] queued = null;
        private long counter = 0L;
        private int width;
        private int height;
        private SimpleImage ip;

        public WatershedQueueWrapper(SimpleImage ip, SimpleImage ipLabels, double minThreshold) {
            this.ip = ip;
            this.width = ip.getWidth();
            this.height = ip.getHeight();
            this.queued = new boolean[this.width * this.height];
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    boolean front;
                    float val = ip.getValue(x, y);
                    if ((double)val <= minThreshold) {
                        this.queued[y * this.width + x] = true;
                        continue;
                    }
                    if (ipLabels.getValue(x, y) != 0.0f) {
                        this.queued[y * this.width + x] = true;
                        continue;
                    }
                    boolean bl = front = x > 0 && ipLabels.getValue(x - 1, y) != 0.0f || y > 0 && ipLabels.getValue(x, y - 1) != 0.0f || x < this.width - 1 && ipLabels.getValue(x + 1, y) != 0.0f || y > this.height - 1 && ipLabels.getValue(x, y + 1) != 0.0f;
                    if (!front) continue;
                    this.queued[y * this.width + x] = true;
                    this.queue.add(new PixelWithValue(x, y, val, ++this.counter));
                }
            }
        }

        public final void add(int x, int y) {
            if (!this.mayAddToQueue(x, y)) {
                return;
            }
            this.addWithoutCheck(x, y, this.ip.getValue(x, y));
        }

        protected final void addWithoutCheck(int x, int y, float val) {
            this.queue.add(new PixelWithValue(x, y, val, ++this.counter));
            this.queued[y * this.width + x] = true;
        }

        public final boolean mayAddToQueue(int x, int y) {
            return x >= 0 && x < this.width && y >= 0 && y < this.height && !this.queued[y * this.width + x];
        }

        public final PixelWithValue poll() {
            return this.queue.poll();
        }

        public final boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }

    private static final class PixelWithValue
    implements Comparable<PixelWithValue> {
        public int x;
        public int y;
        public float value;
        private long count;

        public PixelWithValue(int x, int y, float value, long count) {
            this.x = x;
            this.y = y;
            this.value = value;
            this.count = count;
        }

        @Override
        public int compareTo(PixelWithValue pwv) {
            if (this.value < pwv.value) {
                return 1;
            }
            if (this.value > pwv.value) {
                return -1;
            }
            return this.count > pwv.count ? 1 : -1;
        }
    }
}

