/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.algorithms;

import qupath.lib.analysis.images.SimpleImage;
import qupath.lib.analysis.images.SimpleModifiableImage;

public class MorphologicalReconstruction {
    private static int dilateAndCompare(SimpleModifiableImage ipMarker, SimpleImage ipMask, boolean reverse, IntDequeue queue) {
        int vEnd;
        int hEnd;
        int hStart;
        int inc;
        if (reverse) {
            inc = -1;
            hStart = ipMarker.getWidth() - 1;
            vStart = ipMarker.getHeight() - 1;
            hEnd = -1;
            vEnd = -1;
        } else {
            inc = 1;
            hStart = 0;
            vStart = 0;
            hEnd = ipMarker.getWidth();
            vEnd = ipMarker.getHeight();
        }
        boolean populateQueue = queue != null;
        int width = ipMarker.getWidth();
        int changes = 0;
        boolean firstRow = true;
        for (int y = vStart; y != vEnd; y += inc) {
            float valP3;
            float valP2;
            float valP1;
            float valPrevious = ipMarker.getValue(hStart, y);
            if (firstRow) {
                valP1 = valPrevious;
                valP2 = valPrevious;
                valP3 = valPrevious;
            } else {
                valP1 = valP2 = ipMarker.getValue(hStart, y - inc);
            }
            boolean firstColumn = true;
            for (int x = hStart; x != hEnd; x += inc) {
                float valCurrent = ipMarker.getValue(x, y);
                if (firstRow) {
                    valP1 = valCurrent;
                    valP2 = valCurrent;
                    valP3 = valCurrent;
                } else {
                    valP3 = x + inc != hEnd ? ipMarker.getValue(x + inc, y - inc) : valCurrent;
                }
                float valNeighbourMax = valP1 >= valP2 ? valP1 : valP2;
                valNeighbourMax = valNeighbourMax >= valP3 ? valNeighbourMax : valP3;
                float f = valNeighbourMax = valNeighbourMax >= valPrevious ? valNeighbourMax : valPrevious;
                if (valCurrent < valNeighbourMax) {
                    float valNew;
                    float valMask = ipMask.getValue(x, y);
                    float f2 = valNew = valNeighbourMax >= valMask ? valMask : valNeighbourMax;
                    if (valNew > valCurrent) {
                        valCurrent = valNew;
                        ipMarker.setValue(x, y, valCurrent);
                        ++changes;
                    }
                }
                if (populateQueue) {
                    boolean addToQueue = false;
                    if (valPrevious < valCurrent && valPrevious < ipMask.getValue(x - inc, y)) {
                        addToQueue = true;
                    } else if (!firstRow) {
                        if (!firstColumn && valP1 < valCurrent && valP1 < ipMask.getValue(x - inc, y - inc)) {
                            addToQueue = true;
                        } else if (valP2 < valCurrent && valP2 < ipMask.getValue(x, y - inc)) {
                            addToQueue = true;
                        } else if (valP3 < valCurrent && valP3 < ipMask.getValue(x + inc, y - inc)) {
                            addToQueue = true;
                        }
                    }
                    if (addToQueue) {
                        queue.add(y * width + x);
                    }
                }
                valPrevious = valCurrent;
                valP1 = valP2;
                valP2 = valP3;
                firstColumn = false;
            }
            firstRow = false;
        }
        return changes;
    }

    private static void processPoint(SimpleModifiableImage ipMarker, SimpleImage ipMask, int x, int y, float val, IntDequeue queue, int width) {
        float valTempMask;
        float valTempMarker = ipMarker.getValue(x, y);
        if (valTempMarker < val && valTempMarker < (valTempMask = ipMask.getValue(x, y))) {
            ipMarker.setValue(x, y, valTempMask <= val ? valTempMask : val);
            queue.add(y * width + x);
        }
    }

    private static boolean processQueue(SimpleModifiableImage ipMarker, SimpleImage ipMask, IntDequeue queue) {
        int x1 = 0;
        int y1 = 0;
        int x2 = ipMarker.getWidth();
        int y2 = ipMarker.getHeight();
        int counter = 0;
        int width = ipMarker.getWidth();
        Thread currentThread = Thread.currentThread();
        while (!queue.isEmpty()) {
            if (++counter % 2500 == 0 && currentThread.isInterrupted()) {
                return false;
            }
            int ind = queue.remove();
            int x = ind % width;
            int y = ind / width;
            float val = ipMarker.getValue(x, y);
            if (x > x1) {
                MorphologicalReconstruction.processPoint(ipMarker, ipMask, x - 1, y, val, queue, width);
                if (y > y1) {
                    MorphologicalReconstruction.processPoint(ipMarker, ipMask, x - 1, y - 1, val, queue, width);
                }
                if (y < y2 - 1) {
                    MorphologicalReconstruction.processPoint(ipMarker, ipMask, x - 1, y + 1, val, queue, width);
                }
            }
            if (x < x2 - 1) {
                MorphologicalReconstruction.processPoint(ipMarker, ipMask, x + 1, y, val, queue, width);
                if (y > y1) {
                    MorphologicalReconstruction.processPoint(ipMarker, ipMask, x + 1, y - 1, val, queue, width);
                }
                if (y < y2 - 1) {
                    MorphologicalReconstruction.processPoint(ipMarker, ipMask, x + 1, y + 1, val, queue, width);
                }
            }
            if (y > y1) {
                MorphologicalReconstruction.processPoint(ipMarker, ipMask, x, y - 1, val, queue, width);
            }
            if (y >= y2 - 1) continue;
            MorphologicalReconstruction.processPoint(ipMarker, ipMask, x, y + 1, val, queue, width);
        }
        return true;
    }

    public static boolean morphologicalReconstruction(SimpleModifiableImage imMarker, SimpleImage imMask) {
        MorphologicalReconstruction.dilateAndCompare(imMarker, imMask, false, null);
        IntDequeue queue = new IntDequeue(0x100000);
        MorphologicalReconstruction.dilateAndCompare(imMarker, imMask, true, queue);
        return MorphologicalReconstruction.processQueue(imMarker, imMask, queue);
    }

    static class IntDequeue {
        private int[] array;
        private int head = 0;
        private int tail = 0;
        private static int MAX_EXPANSION = 10240;

        public IntDequeue(int capacity) {
            this.array = new int[capacity];
            this.head = 0;
            this.tail = 0;
        }

        public boolean isEmpty() {
            return this.tail == this.head;
        }

        public int remove() {
            ++this.head;
            return this.array[this.head - 1];
        }

        public void add(int val) {
            if (this.tail < this.array.length) {
                this.array[this.tail] = val;
                ++this.tail;
                return;
            }
            if (this.head != 0) {
                if (this.tail > this.head) {
                    System.arraycopy(this.array, this.head, this.array, 0, this.tail - this.head);
                }
                this.tail -= this.head;
                this.head = 0;
                this.array[this.tail] = val;
                ++this.tail;
                return;
            }
            int[] array2 = new int[Math.max(this.array.length * 2, MAX_EXPANSION)];
            System.arraycopy(this.array, 0, array2, 0, this.array.length);
            this.array = array2;
            this.array[this.tail] = val;
            ++this.tail;
        }
    }
}

