/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.algorithms;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.stats.Histogram;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.color.ColorDeconvolutionHelper;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.StainVector;
import qupath.lib.common.ColorTools;

public class EstimateStainVectors {
    private static final Logger logger = LoggerFactory.getLogger(EstimateStainVectors.class);

    public static ColorDeconvolutionStains estimateStains(BufferedImage img, ColorDeconvolutionStains stainsOriginal, boolean checkColors) {
        double maxStain = 1.0;
        double minStain = 0.05;
        double ignorePercentage = 1.0;
        return EstimateStainVectors.estimateStains(img, stainsOriginal, minStain, maxStain, ignorePercentage, checkColors);
    }

    public static ColorDeconvolutionStains estimateStains(BufferedImage img, ColorDeconvolutionStains stainsOriginal, double minStain, double maxStain, double ignorePercentage, boolean checkColors) {
        float[] blue;
        float[] green;
        float[] red;
        if (BufferedImageTools.is8bitColorType((int)img.getType())) {
            int[] buf = img.getRGB(0, 0, img.getWidth(), img.getHeight(), null, 0, img.getWidth());
            red = ColorDeconvolutionHelper.getRedOpticalDensities((int[])buf, (double)stainsOriginal.getMaxRed(), null);
            green = ColorDeconvolutionHelper.getGreenOpticalDensities((int[])buf, (double)stainsOriginal.getMaxGreen(), null);
            blue = ColorDeconvolutionHelper.getBlueOpticalDensities((int[])buf, (double)stainsOriginal.getMaxBlue(), null);
        } else {
            WritableRaster raster = img.getRaster();
            red = raster.getSamples(0, 0, raster.getWidth(), raster.getHeight(), 0, (float[])null);
            green = raster.getSamples(0, 0, raster.getWidth(), raster.getHeight(), 1, (float[])null);
            blue = raster.getSamples(0, 0, raster.getWidth(), raster.getHeight(), 2, (float[])null);
            ColorDeconvolutionHelper.convertToOpticalDensity((float[])red, (double)stainsOriginal.getMaxRed());
            ColorDeconvolutionHelper.convertToOpticalDensity((float[])green, (double)stainsOriginal.getMaxGreen());
            ColorDeconvolutionHelper.convertToOpticalDensity((float[])blue, (double)stainsOriginal.getMaxBlue());
        }
        return EstimateStainVectors.estimateStains(red, green, blue, stainsOriginal, minStain, maxStain, ignorePercentage, checkColors);
    }

    public static ColorDeconvolutionStains estimateStains(float[] redOD, float[] greenOD, float[] blueOD, ColorDeconvolutionStains stainsOriginal, double minStain, double maxStain, double ignorePercentage, boolean checkColors) {
        double alpha = ignorePercentage / 100.0;
        int n = redOD.length;
        if (greenOD.length != n || blueOD.length != n) {
            throw new IllegalArgumentException("All pixel arrays must be the same length!");
        }
        float[] red = Arrays.copyOf(redOD, n);
        float[] green = Arrays.copyOf(greenOD, n);
        float[] blue = Arrays.copyOf(blueOD, n);
        boolean doColorTestForHE = checkColors && stainsOriginal.isH_E();
        boolean doGrayTest = checkColors && (stainsOriginal.isH_E() || stainsOriginal.isH_DAB());
        double sqrt3 = 1.0 / Math.sqrt(3.0);
        double grayThreshold = Math.cos(0.15);
        int keepCount = 0;
        double maxStainSq = maxStain * maxStain;
        for (int i = 0; i < n; ++i) {
            float r = red[i];
            float g = green[i];
            float b = blue[i];
            double magSquared = r * r + g * g + b * b;
            if (magSquared > maxStainSq || (double)r < minStain || (double)g < minStain || (double)b < minStain || magSquared <= 0.0 || doColorTestForHE && (r > g || b > g) || doGrayTest && ((double)r * sqrt3 + (double)g * sqrt3 + (double)b * sqrt3) / Math.sqrt(magSquared) >= grayThreshold) continue;
            red[keepCount] = r;
            green[keepCount] = g;
            blue[keepCount] = b;
            ++keepCount;
        }
        if (keepCount <= 1) {
            throw new IllegalArgumentException("Not enough pixels remain after applying stain thresholds!");
        }
        if (keepCount < n) {
            red = Arrays.copyOf(red, keepCount);
            green = Arrays.copyOf(green, keepCount);
            blue = Arrays.copyOf(blue, keepCount);
        }
        double[][] cov = new double[3][3];
        cov[0][0] = EstimateStainVectors.covariance(red, red);
        cov[1][1] = EstimateStainVectors.covariance(green, green);
        cov[2][2] = EstimateStainVectors.covariance(blue, blue);
        cov[0][1] = EstimateStainVectors.covariance(red, green);
        cov[0][2] = EstimateStainVectors.covariance(red, blue);
        cov[1][2] = EstimateStainVectors.covariance(green, blue);
        cov[2][1] = cov[1][2];
        cov[2][0] = cov[0][2];
        cov[1][0] = cov[0][1];
        RealMatrix mat = MatrixUtils.createRealMatrix((double[][])cov);
        logger.debug("Covariance matrix:\n {}", (Object)EstimateStainVectors.getMatrixAsString(mat.getData()));
        EigenDecomposition eigen = new EigenDecomposition(mat);
        double[] eigenValues = eigen.getRealEigenvalues();
        int[] eigenOrder = EstimateStainVectors.rank(eigenValues);
        double[] eigen1 = eigen.getEigenvector(eigenOrder[2]).toArray();
        double[] eigen2 = eigen.getEigenvector(eigenOrder[1]).toArray();
        logger.debug("First eigenvector: {}", (Object)EstimateStainVectors.getVectorAsString(eigen1));
        logger.debug("Second eigenvector: {}", (Object)EstimateStainVectors.getVectorAsString(eigen2));
        double[] phi = new double[keepCount];
        for (int i = 0; i < keepCount; ++i) {
            double r = red[i];
            double g = green[i];
            double b = blue[i];
            phi[i] = Math.atan2(r * eigen1[0] + g * eigen1[1] + b * eigen1[2], r * eigen2[0] + g * eigen2[1] + b * eigen2[2]);
        }
        int[] inds = EstimateStainVectors.rank(phi);
        int ind1 = inds[Math.max(0, (int)(alpha * (double)keepCount + 0.5))];
        int ind2 = inds[Math.min(inds.length - 1, (int)((1.0 - alpha) * (double)keepCount + 0.5))];
        StainVector s1 = StainVector.createStainVector((String)stainsOriginal.getStain(1).getName(), (double)red[ind1], (double)green[ind1], (double)blue[ind1]);
        StainVector s2 = StainVector.createStainVector((String)stainsOriginal.getStain(2).getName(), (double)red[ind2], (double)green[ind2], (double)blue[ind2]);
        if (stainsOriginal.isH_E()) {
            if (s1.getRed() < s2.getRed()) {
                s1 = StainVector.createStainVector((String)stainsOriginal.getStain(1).getName(), (double)red[ind2], (double)green[ind2], (double)blue[ind2]);
                s2 = StainVector.createStainVector((String)stainsOriginal.getStain(2).getName(), (double)red[ind1], (double)green[ind1], (double)blue[ind1]);
            }
        } else {
            double angle11 = StainVector.computeAngle((StainVector)s1, (StainVector)stainsOriginal.getStain(1));
            double angle12 = StainVector.computeAngle((StainVector)s1, (StainVector)stainsOriginal.getStain(2));
            double angle21 = StainVector.computeAngle((StainVector)s2, (StainVector)stainsOriginal.getStain(1));
            double angle22 = StainVector.computeAngle((StainVector)s2, (StainVector)stainsOriginal.getStain(2));
            if (Math.min(angle12, angle21) < Math.min(angle11, angle22)) {
                s1 = StainVector.createStainVector((String)stainsOriginal.getStain(1).getName(), (double)red[ind2], (double)green[ind2], (double)blue[ind2]);
                s2 = StainVector.createStainVector((String)stainsOriginal.getStain(2).getName(), (double)red[ind1], (double)green[ind1], (double)blue[ind1]);
            }
        }
        return new ColorDeconvolutionStains(stainsOriginal.getName(), s1, s2, stainsOriginal.getMaxRed(), stainsOriginal.getMaxGreen(), stainsOriginal.getMaxBlue());
    }

    static int[] rank(double[] values) {
        int n = values.length;
        Integer[] indexes = new Integer[n];
        Double[] data = new Double[n];
        for (int i = 0; i < n; ++i) {
            indexes[i] = i;
            data[i] = values[i];
        }
        Arrays.sort(indexes, Comparator.comparing(o -> data[o]));
        int[] indexes2 = new int[n];
        for (int i = 0; i < n; ++i) {
            indexes2[i] = indexes[i];
        }
        return indexes2;
    }

    static String getMatrixAsString(double[][] data) {
        StringBuilder sb = new StringBuilder();
        double[][] dArray = data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double d : row = dArray[i]) {
                sb.append(d).append(",\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    static String getVectorAsString(double[] data) {
        StringBuilder sb = new StringBuilder();
        for (double d : data) {
            sb.append(d).append(", ");
        }
        return sb.toString();
    }

    static double covariance(float[] x, float[] y) {
        int n = x.length;
        if (n != y.length) {
            throw new IllegalArgumentException("Cannot compute covariance - array lengths are not the same");
        }
        double xMean = 0.0;
        for (float v : x) {
            xMean += (double)v / (double)n;
        }
        double yMean = 0.0;
        for (float v : y) {
            yMean += (double)v / (double)n;
        }
        double result = 0.0;
        for (int i = 0; i < n; ++i) {
            double xDev = (double)x[i] - xMean;
            double yDev = (double)y[i] - yMean;
            result += xDev * yDev / (double)n;
        }
        return result;
    }

    public static int[] subsample(int[] arr, int maxEntries) {
        if (arr.length <= maxEntries) {
            return arr;
        }
        int spacing = (int)Math.ceil((double)arr.length / (double)maxEntries);
        int[] arr2 = new int[arr.length / spacing];
        for (int i = 0; i < arr2.length; ++i) {
            arr2[i] = arr[i * spacing];
        }
        logger.debug("Array with {} entries subsampled to have {} entries (max requested {})", new Object[]{arr.length, arr2.length, maxEntries});
        return arr2;
    }

    public static BufferedImage smoothImage(BufferedImage img) {
        ConvolveOp op = new ConvolveOp(new Kernel(3, 3, new float[]{0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f, 0.11111111f}), 1, null);
        BufferedImage img2 = op.filter(img, null);
        return op.filter(img2, null);
    }

    public static int[] getModeRGB(int[] rgb) {
        int[] rh = new int[256];
        int[] gh = new int[256];
        int[] bh = new int[256];
        for (int v : rgb) {
            int n = ColorTools.red((int)v);
            rh[n] = rh[n] + 1;
            int n2 = ColorTools.green((int)v);
            gh[n2] = gh[n2] + 1;
            int n3 = ColorTools.blue((int)v);
            bh[n3] = bh[n3] + 1;
        }
        int rMax = 0;
        int gMax = 0;
        int bMax = 0;
        int rMaxCount = -1;
        int gMaxCount = -1;
        int bMaxCount = -1;
        for (int i = 255; i >= 0; --i) {
            if (rh[i] > rMaxCount) {
                rMaxCount = rh[i];
                rMax = i;
            }
            if (gh[i] > gMaxCount) {
                gMaxCount = gh[i];
                gMax = i;
            }
            if (bh[i] <= bMaxCount) continue;
            bMaxCount = bh[i];
            bMax = i;
        }
        return new int[]{rMax, gMax, bMax};
    }

    public static float getMode(float[] values, int nBins) {
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        boolean allInt = true;
        for (float v : values) {
            if (!Float.isFinite(v)) continue;
            min = Math.min(min, v);
            max = Math.max(max, v);
            if (allInt && (double)v == Math.rint(v)) continue;
            allInt = false;
        }
        if (min == max) {
            return min;
        }
        boolean useBinsDirectly = false;
        if (allInt && max - min <= (float)nBins) {
            nBins = (int)(max - min);
            useBinsDirectly = true;
        }
        Histogram hist = new Histogram(values, nBins, (double)min, (double)max);
        long maxCount = hist.getMaxCount();
        for (int i = nBins - 1; i >= 0; --i) {
            if (hist.getCountsForBin(i) != maxCount) continue;
            if (useBinsDirectly) {
                return (float)hist.getBinLeftEdge(i);
            }
            return (float)((hist.getBinLeftEdge(i) + hist.getBinRightEdge(i)) / 2.0);
        }
        logger.warn("No mode found for histogram!");
        return (min + max) / 2.0f;
    }
}

