/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.ImmutableDimension;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.plugins.AbstractDetectionPlugin;
import qupath.lib.plugins.PathTask;
import qupath.lib.plugins.parameters.Parameter;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class TilerPlugin<T>
extends AbstractDetectionPlugin<T> {
    private ParameterList params = new ParameterList();

    public TilerPlugin() {
        this.params.addTitleParameter("Tile options");
        this.params.addDoubleParameter("tileSizeMicrons", "Tile size", 100.0, GeneralTools.micrometerSymbol(), "Specify tile width and height, in " + GeneralTools.micrometerSymbol());
        this.params.addDoubleParameter("tileSizePx", "Tile size", 200.0, "px", "Specify tile width and height, in pixels");
        this.params.addBooleanParameter("trimToROI", "Trim to ROI", true, "Trim tiles to match the parent ROI shape, rather than overlap boundaries with full squares");
        this.params.addTitleParameter("Annotation options");
        this.params.addBooleanParameter("makeAnnotations", "Make annotation tiles", false, "Create annotation objects, rather than tile objects");
        this.params.addBooleanParameter("removeParentAnnotation", "Remove parent annotation", false, "Remove the parent object, if it was an annotation; has no effect if 'Make annotation tiles' is not selected, or the parent object is not an annotation");
    }

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        return Arrays.asList(TMACoreObject.class, PathAnnotationObject.class);
    }

    public ParameterList getDefaultParameterList(ImageData<T> imageData) {
        boolean pixelsInMicrons = imageData.getServer().getPixelCalibration().hasPixelSizeMicrons();
        ((Parameter)this.params.getParameters().get("tileSizeMicrons")).setHidden(!pixelsInMicrons);
        ((Parameter)this.params.getParameters().get("tileSizePx")).setHidden(pixelsInMicrons);
        return this.params;
    }

    public String getName() {
        return "Create tiles";
    }

    public String getLastResultsDescription() {
        return null;
    }

    protected void addRunnableTasks(ImageData<T> imageData, PathObject parentObject, List<Runnable> tasks) {
        tasks.add((Runnable)((Object)new TileCreator(imageData, parentObject, this.params)));
    }

    public String getDescription() {
        return "Create square tiles to use later for feature measurements";
    }

    static class TileCreator
    implements PathTask {
        private ParameterList params;
        private PathObject parentObject;
        private ImageData<?> imageData;
        private List<PathObject> tiles;
        private String lastMessage = null;

        TileCreator(ImageData<?> imageData, PathObject parentObject, ParameterList params) {
            this.parentObject = parentObject;
            this.imageData = imageData;
            this.params = params;
        }

        public static <T> ImmutableDimension getPreferredTileSizePixels(ParameterList params, ImageServer<T> server) {
            int tileHeight;
            int tileWidth;
            PixelCalibration cal = server.getPixelCalibration();
            if (cal.hasPixelSizeMicrons()) {
                double tileSize = params.getDoubleParameterValue("tileSizeMicrons");
                tileWidth = (int)(tileSize / cal.getPixelWidthMicrons() + 0.5);
                tileHeight = (int)(tileSize / cal.getPixelHeightMicrons() + 0.5);
            } else {
                tileHeight = tileWidth = (int)(params.getDoubleParameterValue("tileSizePx") + 0.5);
            }
            return ImmutableDimension.getInstance((int)tileWidth, (int)tileHeight);
        }

        private PathObject createTile(ROI pathROI, ParameterList params, ImageServer<?> server) throws InterruptedException {
            return Boolean.TRUE.equals(params.getBooleanParameterValue("makeAnnotations")) ? PathObjects.createAnnotationObject((ROI)pathROI) : PathObjects.createTileObject((ROI)pathROI);
        }

        public String getLastResultsDescription() {
            return this.lastMessage;
        }

        public void run() {
            ROI roi = this.parentObject.getROI();
            if (roi == null || !roi.isArea()) {
                this.lastMessage = "Cannot tile ROI " + String.valueOf(roi) + " - does not represent an area region of interest";
                return;
            }
            ImageServer server = this.imageData.getServer();
            ImmutableDimension tileSize = TileCreator.getPreferredTileSizePixels(this.params, server);
            int tileWidth = tileSize.width;
            int tileHeight = tileSize.height;
            boolean trimToROI = this.params.getBooleanParameterValue("trimToROI");
            List pathROIs = RoiTools.makeTiles((ROI)roi, (int)tileWidth, (int)tileHeight, (boolean)trimToROI);
            this.tiles = new ArrayList<PathObject>(pathROIs.size());
            Iterator iter = pathROIs.iterator();
            int idx = 0;
            while (iter.hasNext()) {
                try {
                    PathObject tile = this.createTile((ROI)iter.next(), this.params, server);
                    if (tile == null) continue;
                    tile.setName("Tile " + ++idx);
                    this.tiles.add(tile);
                }
                catch (InterruptedException e) {
                    this.lastMessage = "Tile creation interrupted for " + String.valueOf(this.parentObject);
                    return;
                }
                catch (Exception e) {
                    iter.remove();
                }
            }
            this.lastMessage = this.tiles.size() + " tiles created";
        }

        public void taskComplete(boolean wasCancelled) {
            if (wasCancelled) {
                return;
            }
            this.parentObject.clearChildObjects();
            this.parentObject.addChildObjects(this.tiles);
            if (this.parentObject.isAnnotation()) {
                ((PathAnnotationObject)this.parentObject).setLocked(true);
            }
            this.imageData.getHierarchy().fireHierarchyChangedEvent((Object)this, this.parentObject);
            if (this.params.getBooleanParameterValue("removeParentAnnotation").booleanValue() && this.params.getBooleanParameterValue("makeAnnotations").booleanValue() && this.parentObject.isAnnotation()) {
                this.imageData.getHierarchy().removeObject(this.parentObject, true);
            }
        }
    }
}

