/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.algorithms;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.analysis.features.HaralickFeatureComputer;
import qupath.lib.analysis.features.HaralickFeatures;
import qupath.lib.analysis.images.SimpleImage;
import qupath.lib.analysis.images.SimpleImages;
import qupath.lib.analysis.images.SimpleModifiableImage;
import qupath.lib.analysis.stats.RunningStatistics;
import qupath.lib.analysis.stats.StatisticsHelper;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.ColorTransformer;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.ImmutableDimension;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.plugins.AbstractInteractivePlugin;
import qupath.lib.plugins.parameters.Parameter;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

public class HaralickFeaturesPlugin
extends AbstractInteractivePlugin<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(HaralickFeaturesPlugin.class);
    private ParameterList params = new ParameterList().addDoubleParameter("downsample", "Downsample", 1.0, null, "Amount to downsample the image before calculating textures; choose 1 to use full resolution, or a higher value to use a smaller image").addDoubleParameter("magnification", "Magnification", 5.0, null, "Magnification factor of the image used to calculate the textures").addDoubleParameter("pixelSizeMicrons", "Preferred pixel size", 2.0, GeneralTools.micrometerSymbol(), "Preferred pixel size of the image used to calculate the textures - higher values means coarser (lower resolution) images").addChoiceParameter("stainChoice", "Color transforms", (Object)"Optical density", Arrays.asList("Optical density", "H-DAB", "H&E", "H-DAB (8-bit)", "H&E (8-bit)", "RGB OD", "RGB", "Grayscale", "HSB"), "Color transforms to apply before calculating textures");

    public HaralickFeaturesPlugin() {
        this.params.addDoubleParameter("tileSizeMicrons", "Tile diameter", 25.0, GeneralTools.micrometerSymbol(), "Diameter of square tile around the object centroid used to calculate textures.\nIf <= 0, the tile itself will be used to defined the ROI in which textures are calculated");
        this.params.addDoubleParameter("tileSizePx", "Tile diameter", 200.0, "px (full resolution image)", "Diameter of square tile around the object centroid used to calculate textures.\nIf <= 0, the tile itself will be used to defined the ROI in which textures are calculated");
        this.params.addBooleanParameter("includeStats", "Include basic statistics", true, "Include basic statistics (mean, min, max, std dev) as well as Haralick textures").addBooleanParameter("doCircular", "Use circular tiles", false, "If the tile diameter > 0, calculate textures in a circular (rather than square) region around the centroid of each object").addBooleanParameter("useNucleusROIs", "Use cell nucleus ROIs", true, "If textures are computed around cell objects, the nucleus ROI is used where available").addIntParameter("haralickDistance", "Haralick distance", 1, null, "Spacing between pixels used in computing the co-occurrence matrix for Haralick textures (default = 1)").addIntParameter("haralickBins", "Haralick number of bins", 32, null, 8.0, 256.0, "Number of intensity bins to use when computing the co-occurrence matrix for Haralick textures (default = 32)");
    }

    static ImmutableDimension getPreferredTileSizePixels(ImageServer<BufferedImage> server, ParameterList params) {
        int tileHeight;
        int tileWidth;
        PixelCalibration cal = server.getPixelCalibration();
        if (cal.hasPixelSizeMicrons()) {
            double tileSize = params.getDoubleParameterValue("tileSizeMicrons");
            tileWidth = (int)(tileSize / cal.getPixelWidthMicrons() + 0.5);
            tileHeight = (int)(tileSize / cal.getPixelHeightMicrons() + 0.5);
        } else {
            tileHeight = tileWidth = (int)(params.getDoubleParameterValue("tileSizePx") + 0.5);
        }
        return ImmutableDimension.getInstance((int)tileWidth, (int)tileHeight);
    }

    static String getDiameterString(ImageServer<BufferedImage> server, ParameterList params) {
        if (server.getPixelCalibration().hasPixelSizeMicrons()) {
            return String.format("%.1f %s", params.getDoubleParameterValue("tileSizeMicrons"), GeneralTools.micrometerSymbol());
        }
        return String.format("%d px", (int)(params.getDoubleParameterValue("tileSizePx") + 0.5));
    }

    protected void addRunnableTasks(ImageData<BufferedImage> imageData, PathObject parentObject, List<Runnable> tasks) {
        ParameterList params = this.getParameterList(imageData);
        ImageServer server = imageData.getServer();
        tasks.add(new HaralickRunnable((ImageServer<BufferedImage>)server, parentObject, params, imageData.getColorDeconvolutionStains()));
    }

    static boolean processObject(PathObject pathObject, ParameterList params, ImageServer<BufferedImage> server, ColorDeconvolutionStains stains) throws IOException {
        String postfix;
        RegionRequest region;
        String stainsName = (String)params.getChoiceParameterValue("stainChoice");
        double mag = params.getDoubleParameterValue("magnification");
        int d = params.getIntParameterValue("haralickDistance");
        int nBins = params.getIntParameterValue("haralickBins");
        boolean includeStats = params.getBooleanParameterValue("includeStats");
        boolean doCircular = params.getBooleanParameterValue("doCircular");
        boolean hasMagnification = !Double.isNaN(server.getMetadata().getMagnification());
        PixelCalibration cal = server.getPixelCalibration();
        double downsample = hasMagnification ? server.getMetadata().getMagnification() / mag : (cal.hasPixelSizeMicrons() ? params.getDoubleParameterValue("pixelSizeMicrons") / cal.getAveragedPixelSizeMicrons() : params.getDoubleParameterValue("downsample"));
        ROI pathROI = null;
        pathROI = pathObject instanceof PathCellObject && Boolean.TRUE.equals(params.getBooleanParameterValue("useNucleusROIs")) ? ((PathCellObject)pathObject).getNucleusROI() : pathObject.getROI();
        if (pathROI == null) {
            return false;
        }
        ImmutableDimension size = HaralickFeaturesPlugin.getPreferredTileSizePixels(server, params);
        boolean createMaskROI = false;
        if (size.getWidth() <= 0 || size.getHeight() <= 0) {
            region = RegionRequest.createInstance((String)server.getPath(), (double)downsample, (ROI)pathObject.getROI());
            createMaskROI = true;
            doCircular = false;
        } else {
            if ((double)size.getWidth() / downsample < 1.0 || (double)size.getHeight() / downsample < 1.0) {
                return false;
            }
            int xStart = (int)((double)((int)(pathROI.getCentroidX() / downsample + 0.5)) * downsample) - size.width / 2;
            int yStart = (int)((double)((int)(pathROI.getCentroidY() / downsample + 0.5)) * downsample) - size.height / 2;
            int width = Math.min(server.getWidth(), xStart + size.width) - xStart;
            int height = Math.min(server.getHeight(), yStart + size.height) - yStart;
            region = RegionRequest.createInstance((String)server.getPath(), (double)downsample, (int)xStart, (int)yStart, (int)width, (int)height, (int)pathROI.getT(), (int)pathROI.getZ());
        }
        if ((double)region.getWidth() / downsample < 3.0 || (double)region.getHeight() / downsample < 3.0) {
            return false;
        }
        BufferedImage img = (BufferedImage)server.readRegion(region);
        if (img == null) {
            logger.error("Could not read image - unable to compute Haralick features for {}", (Object)pathObject);
            return false;
        }
        byte[] maskBytes = null;
        if (createMaskROI) {
            ROI roi = pathObject.getROI();
            BufferedImage imgMask = BufferedImageTools.createROIMask((int)img.getWidth(), (int)img.getHeight(), (ROI)roi, (RegionRequest)region);
            maskBytes = ((DataBufferByte)imgMask.getRaster().getDataBuffer()).getData();
        }
        double minValue = Double.NaN;
        double maxValue = Double.NaN;
        int w = img.getWidth();
        int h = img.getHeight();
        int[] buf = img.getRGB(0, 0, w, h, null, 0, w);
        float[] pixels = new float[buf.length];
        SimpleModifiableImage pxImg = SimpleImages.createFloatImage((float[])pixels, (int)w, (int)h);
        MeasurementList measurementList = pathObject.getMeasurementList();
        String string = postfix = maskBytes == null ? " (" + HaralickFeaturesPlugin.getDiameterString(server, params) + ")" : "";
        if (stainsName.equals("H-DAB")) {
            minValue = 0.0;
            maxValue = 2.0;
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Hematoxylin" + postfix, ColorTransformer.ColorTransformMethod.Hematoxylin_H_DAB, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "DAB" + postfix, ColorTransformer.ColorTransformMethod.DAB_H_DAB, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
        } else if (stainsName.equals("H&E")) {
            minValue = 0.0;
            maxValue = 2.0;
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Hematoxylin" + postfix, ColorTransformer.ColorTransformMethod.Hematoxylin_H_E, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Eosin" + postfix, ColorTransformer.ColorTransformMethod.Eosin_H_E, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
        } else if (stainsName.equals("H-DAB (8-bit)")) {
            minValue = 0.0;
            maxValue = 255.0;
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Hematoxylin 8-bit" + postfix, ColorTransformer.ColorTransformMethod.Hematoxylin_H_DAB_8_bit, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "DAB 8-bit" + postfix, ColorTransformer.ColorTransformMethod.DAB_H_DAB_8_bit, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
        } else if (stainsName.equals("H&E (8-bit)")) {
            minValue = 0.0;
            maxValue = 255.0;
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Hematoxylin 8-bit" + postfix, ColorTransformer.ColorTransformMethod.Hematoxylin_H_E_8_bit, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Eosin 8-bit" + postfix, ColorTransformer.ColorTransformMethod.Eosin_H_E_8_bit, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
        } else if (stainsName.equals("Optical density")) {
            minValue = 0.0;
            maxValue = 2.5;
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "OD sum" + postfix, ColorTransformer.ColorTransformMethod.Optical_density_sum, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
        } else if (stainsName.equals("RGB")) {
            minValue = 0.0;
            maxValue = 255.0;
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Red" + postfix, ColorTransformer.ColorTransformMethod.Red, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Green" + postfix, ColorTransformer.ColorTransformMethod.Green, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Blue" + postfix, ColorTransformer.ColorTransformMethod.Blue, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
        } else if (stainsName.equals("RGB OD")) {
            minValue = 0.0;
            maxValue = 1.5;
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Red OD" + postfix, ColorTransformer.ColorTransformMethod.Red_OD, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Green OD" + postfix, ColorTransformer.ColorTransformMethod.Green_OD, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Blue OD" + postfix, ColorTransformer.ColorTransformMethod.Blue_OD, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
        } else if (stainsName.equals("Grayscale")) {
            minValue = 0.0;
            maxValue = 255.0;
            HaralickFeaturesPlugin.processTransformedImage(pxImg, buf, pixels, measurementList, "Grayscale" + postfix, ColorTransformer.ColorTransformMethod.RGB_mean, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
        } else if (stainsName.equals("HSB")) {
            minValue = 0.0;
            maxValue = 1.0;
            float[] hsb = null;
            double sinX = 0.0;
            double cosX = 0.0;
            float[] pixelsBrightness = new float[pixels.length];
            float[] pixelsSaturation = new float[pixels.length];
            for (int i = 0; i < buf.length; ++i) {
                if (maskBytes != null && maskBytes[i] == 0) continue;
                int val = buf[i];
                hsb = Color.RGBtoHSB(ColorTools.red((int)val), ColorTools.green((int)val), ColorTools.blue((int)val), hsb);
                pixelsSaturation[i] = hsb[1];
                pixelsBrightness[i] = hsb[2];
                double alpha = (double)(hsb[0] * 2.0f) * Math.PI;
                sinX += Math.sin(alpha);
                cosX += Math.cos(alpha);
            }
            measurementList.put("Mean hue", Math.atan2(sinX, cosX) / (Math.PI * 2) + 0.5);
            HaralickFeaturesPlugin.processTransformedImage(SimpleImages.createFloatImage((float[])pixelsSaturation, (int)w, (int)h), buf, pixelsSaturation, measurementList, "Saturation" + postfix, null, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
            HaralickFeaturesPlugin.processTransformedImage(SimpleImages.createFloatImage((float[])pixelsBrightness, (int)w, (int)h), buf, pixelsBrightness, measurementList, "Brightness" + postfix, null, minValue, maxValue, d, nBins, stains, maskBytes, includeStats, doCircular);
        }
        measurementList.close();
        return true;
    }

    static void processTransformedImage(SimpleModifiableImage pxImg, int[] buf, float[] pixels, MeasurementList measurementList, String name, ColorTransformer.ColorTransformMethod method, double minValue, double maxValue, int d, int nBins, ColorDeconvolutionStains stains, byte[] maskBytes, boolean includeStats, boolean doCircular) {
        if (method != null) {
            ColorTransformer.getTransformedPixels((int[])buf, (ColorTransformer.ColorTransformMethod)method, (float[])pixels, (ColorDeconvolutionStains)stains);
        }
        if (doCircular) {
            double w = pxImg.getWidth();
            double h = pxImg.getHeight();
            double cx = (w - 1.0) / 2.0;
            double cy = (h - 1.0) / 2.0;
            double radius = Math.max(w, h) * 0.5;
            double distThreshold = radius * radius;
            int y = 0;
            while ((double)y < h) {
                int x = 0;
                while ((double)x < w) {
                    if ((cx - (double)x) * (cx - (double)x) + (cy - (double)y) * (cy - (double)y) > distThreshold) {
                        pxImg.setValue(x, y, Float.NaN);
                    }
                    ++x;
                }
                ++y;
            }
        }
        if (maskBytes != null) {
            int w = pxImg.getWidth();
            for (int i = 0; i < pixels.length; ++i) {
                if (maskBytes[i] != 0) continue;
                pxImg.setValue(i % w, i / w, Float.NaN);
            }
        }
        if (includeStats) {
            HaralickFeaturesPlugin.addBasicStatistics((SimpleImage)pxImg, measurementList, name);
        }
        if (d > 0) {
            HaralickFeaturesPlugin.addHaralickFeatures(HaralickFeatureComputer.measureHaralick((SimpleImage)pxImg, null, nBins, minValue, maxValue, d), measurementList, name);
        }
    }

    static void addBasicStatistics(SimpleImage img, MeasurementList measurementList, String name) {
        RunningStatistics stats = StatisticsHelper.computeRunningStatistics((SimpleImage)img);
        measurementList.put(name + " Mean", stats.getMean());
        measurementList.put(name + " Min", stats.getMin());
        measurementList.put(name + " Max", stats.getMax());
        measurementList.put(name + " Range", stats.getRange());
        measurementList.put(name + " Std.dev.", stats.getStdDev());
        double m = stats.getMean();
        double skewness = 0.0;
        double kurtosis = 0.0;
        double variance = 0.0;
        double n = stats.size();
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                float val = img.getValue(x, y);
                if (Float.isNaN(val)) continue;
                double d = (double)val - m;
                double d3 = d * d * d;
                variance += d * d / n;
                skewness += d3 / n;
                kurtosis += d3 * d / n;
            }
        }
        measurementList.put(name + " Skewness", skewness / (variance * Math.sqrt(variance)));
        measurementList.put(name + " Kurtosis", kurtosis / (variance * variance));
    }

    static void addHaralickFeatures(HaralickFeatures haralickFeatures, MeasurementList measurementList, String name) {
        for (int i = 0; i < haralickFeatures.nFeatures(); ++i) {
            measurementList.put(String.format("%s Haralick %s (F%d)", name, haralickFeatures.getFeatureName(i), i), haralickFeatures.getFeature(i));
        }
    }

    public ParameterList getDefaultParameterList(ImageData<BufferedImage> imageData) {
        boolean hasMicrons = imageData.getServer().getPixelCalibration().hasPixelSizeMicrons();
        boolean hasMagnification = !Double.isNaN(imageData.getServerMetadata().getMagnification());
        ((Parameter)this.params.getParameters().get("tileSizeMicrons")).setHidden(!hasMicrons);
        ((Parameter)this.params.getParameters().get("tileSizePx")).setHidden(hasMicrons);
        ((Parameter)this.params.getParameters().get("magnification")).setHidden(!hasMagnification);
        ((Parameter)this.params.getParameters().get("pixelSizeMicrons")).setHidden(!hasMicrons || hasMagnification);
        ((Parameter)this.params.getParameters().get("downsample")).setHidden(hasMicrons || hasMagnification);
        return this.params;
    }

    public String getName() {
        return "Add Haralick texture features";
    }

    public String getLastResultsDescription() {
        return "";
    }

    public String getDescription() {
        return "Add Haralick texture features to existing object measurements";
    }

    protected Collection<PathObject> getParentObjects(ImageData<BufferedImage> imageData) {
        return imageData.getHierarchy().getSelectionModel().getSelectedObjects();
    }

    public Collection<Class<? extends PathObject>> getSupportedParentObjectClasses() {
        ArrayList<Class<? extends PathObject>> parents = new ArrayList<Class<? extends PathObject>>();
        parents.add(PathDetectionObject.class);
        parents.add(TMACoreObject.class);
        return parents;
    }

    static class HaralickRunnable
    implements Runnable {
        private ImageServer<BufferedImage> server;
        private ParameterList params;
        private PathObject parentObject;
        private ColorDeconvolutionStains stains;

        public HaralickRunnable(ImageServer<BufferedImage> server, PathObject parentObject, ParameterList params, ColorDeconvolutionStains stains) {
            this.server = server;
            this.parentObject = parentObject;
            this.params = params;
            this.stains = stains;
        }

        @Override
        public void run() {
            try {
                HaralickFeaturesPlugin.processObject(this.parentObject, this.params, this.server, this.stains);
            }
            catch (IOException e) {
                logger.error("Unable to process " + String.valueOf(this.parentObject), (Throwable)e);
            }
            finally {
                this.parentObject.getMeasurementList().close();
                this.server = null;
                this.params = null;
            }
        }

        public String toString() {
            return "Haralick features";
        }
    }
}

