/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.tools;

import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.measure.Calibration;
import ij.process.FloatPolygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import qupath.lib.awt.common.AwtTools;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.EllipseROI;
import qupath.lib.roi.LineROI;
import qupath.lib.roi.PointsROI;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.PolylineROI;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

class ROIConverterIJ {
    ROIConverterIJ() {
    }

    private static double convertXtoIJ(double x, double xOrigin, double downsample) {
        return x / downsample + xOrigin;
    }

    private static double convertYtoIJ(double y, double yOrigin, double downsample) {
        return y / downsample + yOrigin;
    }

    private static Rectangle2D getTransformedBounds(ROI pathROI, double xOrigin, double yOrigin, double downsampleFactor) {
        Rectangle2D bounds = AwtTools.getBounds2D((ROI)pathROI);
        double x1 = ROIConverterIJ.convertXtoIJ(bounds.getMinX(), xOrigin, downsampleFactor);
        double y1 = ROIConverterIJ.convertYtoIJ(bounds.getMinY(), yOrigin, downsampleFactor);
        double x2 = ROIConverterIJ.convertXtoIJ(bounds.getMaxX(), xOrigin, downsampleFactor);
        double y2 = ROIConverterIJ.convertYtoIJ(bounds.getMaxY(), yOrigin, downsampleFactor);
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    private static float[][] getTransformedPoints(Collection<Point2> points, double xOrigin, double yOrigin, double downsampleFactor) {
        float[] xPoints = new float[points.size()];
        float[] yPoints = new float[points.size()];
        int i = 0;
        for (Point2 p : points) {
            xPoints[i] = (float)ROIConverterIJ.convertXtoIJ(p.getX(), xOrigin, downsampleFactor);
            yPoints[i] = (float)ROIConverterIJ.convertYtoIJ(p.getY(), yOrigin, downsampleFactor);
            ++i;
        }
        return new float[][]{xPoints, yPoints};
    }

    static Roi getRectangleROI(RectangleROI pathRectangle, double xOrigin, double yOrigin, double downsampleFactor) {
        Rectangle2D bounds = ROIConverterIJ.getTransformedBounds((ROI)pathRectangle, xOrigin, yOrigin, downsampleFactor);
        return new Roi(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    static OvalRoi convertToOvalROI(EllipseROI pathOval, double xOrigin, double yOrigin, double downsampleFactor) {
        Rectangle2D bounds = ROIConverterIJ.getTransformedBounds((ROI)pathOval, xOrigin, yOrigin, downsampleFactor);
        return new OvalRoi(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
    }

    static Line convertToLineROI(LineROI pathLine, double xOrigin, double yOrigin, double downsampleFactor) {
        return new Line(ROIConverterIJ.convertXtoIJ(pathLine.getX1(), xOrigin, downsampleFactor), ROIConverterIJ.convertYtoIJ(pathLine.getY1(), yOrigin, downsampleFactor), ROIConverterIJ.convertXtoIJ(pathLine.getX2(), xOrigin, downsampleFactor), ROIConverterIJ.convertYtoIJ(pathLine.getY2(), yOrigin, downsampleFactor));
    }

    static PointRoi convertToPointROI(PointsROI pathPoints, double xOrigin, double yOrigin, double downsampleFactor) {
        float[][] points = ROIConverterIJ.getTransformedPoints(pathPoints.getAllPoints(), xOrigin, yOrigin, downsampleFactor);
        return new PointRoi(points[0], points[1]);
    }

    static PolygonRoi convertToPolygonROI(PolygonROI pathPolygon, double xOrigin, double yOrigin, double downsampleFactor) {
        float[][] points = ROIConverterIJ.getTransformedPoints(pathPolygon.getAllPoints(), xOrigin, yOrigin, downsampleFactor);
        return new PolygonRoi(points[0], points[1], 2);
    }

    static PolygonRoi convertToPolygonROI(PolylineROI pathPolygon, double xOrigin, double yOrigin, double downsampleFactor) {
        float[][] points = ROIConverterIJ.getTransformedPoints(pathPolygon.getAllPoints(), xOrigin, yOrigin, downsampleFactor);
        return new PolygonRoi(points[0], points[1], 6);
    }

    static ShapeRoi convertToShapeRoi(ROI roi, double xOrigin, double yOrigin, double downsampleFactor) {
        if (roi != null && roi.isArea()) {
            Area shape = RoiTools.getArea((ROI)roi);
            return ROIConverterIJ.convertToShapeRoi(shape, xOrigin, yOrigin, downsampleFactor);
        }
        throw new UnsupportedOperationException("Only ROIs representing areas can be converted to a ShapeRoi!");
    }

    private static ShapeRoi convertToShapeRoi(Shape shape, double xOrigin, double yOrigin, double downsampleFactor) {
        shape = new AffineTransform(1.0 / downsampleFactor, 0.0, 0.0, 1.0 / downsampleFactor, xOrigin, yOrigin).createTransformedShape(shape);
        return new ShapeRoi(shape);
    }

    private static double convertLocationfromIJ(double xory, double origin, double downsample) {
        return (xory - origin) * downsample;
    }

    static ROI convertToPolylineROI(PolygonRoi roi, double xOrigin, double yOrigin, double downsampleFactor, int c, int z, int t) {
        List<Point2> points = ROIConverterIJ.convertToPointsList(roi.getFloatPolygon(), xOrigin, yOrigin, downsampleFactor);
        if (points == null) {
            return null;
        }
        return ROIs.createPolylineROI(points, (ImagePlane)ImagePlane.getPlaneWithChannel((int)c, (int)z, (int)t));
    }

    static ROI convertToPolygonOrAreaROI(Roi roi, double xOrigin, double yOrigin, double downsampleFactor, int c, int z, int t) {
        if (roi instanceof ShapeRoi) {
            ShapeRoi shapeRoi = (ShapeRoi)roi;
            return ROIConverterIJ.convertToAreaROI(shapeRoi, xOrigin, yOrigin, downsampleFactor, c, z, t);
        }
        return ROIConverterIJ.convertToAreaROI(new ShapeRoi(roi), xOrigin, yOrigin, downsampleFactor, c, z, t);
    }

    static ROI convertToAreaROI(ShapeRoi roi, double xOrigin, double yOrigin, double downsampleFactor, int c, int z, int t) {
        Shape shape = roi.getShape();
        AffineTransform transform = new AffineTransform();
        transform.scale(downsampleFactor, downsampleFactor);
        transform.translate(roi.getXBase(), roi.getYBase());
        transform.translate(-xOrigin, -yOrigin);
        return RoiTools.getShapeROI((Area)new Area(transform.createTransformedShape(shape)), (ImagePlane)ImagePlane.getPlaneWithChannel((int)c, (int)z, (int)t));
    }

    protected static Rectangle2D getTransformedBoundsFromIJ(Roi roi, double xOrigin, double yOrigin, double downsampleFactor) {
        Rectangle bounds = roi.getBounds();
        double x1 = ROIConverterIJ.convertLocationfromIJ(bounds.getMinX(), xOrigin, downsampleFactor);
        double y1 = ROIConverterIJ.convertLocationfromIJ(bounds.getMinY(), yOrigin, downsampleFactor);
        double x2 = ROIConverterIJ.convertLocationfromIJ(bounds.getMaxX(), xOrigin, downsampleFactor);
        double y2 = ROIConverterIJ.convertLocationfromIJ(bounds.getMaxY(), yOrigin, downsampleFactor);
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    static ROI getRectangleROI(Roi roi, double xOrigin, double yOrigin, double downsampleFactor, int c, int z, int t) {
        Rectangle2D bounds = ROIConverterIJ.getTransformedBoundsFromIJ(roi, xOrigin, yOrigin, downsampleFactor);
        return ROIs.createRectangleROI((double)bounds.getX(), (double)bounds.getY(), (double)bounds.getWidth(), (double)bounds.getHeight(), (ImagePlane)ImagePlane.getPlaneWithChannel((int)c, (int)z, (int)t));
    }

    static ROI convertToEllipseROI(Roi roi, double xOrigin, double yOrigin, double downsampleFactor, int c, int z, int t) {
        Rectangle2D bounds = ROIConverterIJ.getTransformedBoundsFromIJ(roi, xOrigin, yOrigin, downsampleFactor);
        return ROIs.createEllipseROI((double)bounds.getX(), (double)bounds.getY(), (double)bounds.getWidth(), (double)bounds.getHeight(), (ImagePlane)ImagePlane.getPlaneWithChannel((int)c, (int)z, (int)t));
    }

    static ROI convertToLineROI(Line roi, double xOrigin, double yOrigin, double downsampleFactor, int c, int z, int t) {
        double x1 = ROIConverterIJ.convertLocationfromIJ(roi.x1d, xOrigin, downsampleFactor);
        double x2 = ROIConverterIJ.convertLocationfromIJ(roi.x2d, xOrigin, downsampleFactor);
        double y1 = ROIConverterIJ.convertLocationfromIJ(roi.y1d, yOrigin, downsampleFactor);
        double y2 = ROIConverterIJ.convertLocationfromIJ(roi.y2d, yOrigin, downsampleFactor);
        return ROIs.createLineROI((double)x1, (double)y1, (double)x2, (double)y2, (ImagePlane)ImagePlane.getPlaneWithChannel((int)c, (int)z, (int)t));
    }

    static ROI convertToPointROI(PolygonRoi roi, double xOrigin, double yOrigin, double downsampleFactor, int c, int z, int t) {
        List<Point2> points = ROIConverterIJ.convertToPointsList(roi.getFloatPolygon(), xOrigin, yOrigin, downsampleFactor);
        return ROIs.createPointsROI(points, (ImagePlane)ImagePlane.getPlaneWithChannel((int)c, (int)z, (int)t));
    }

    static List<Point2> convertToPointsList(FloatPolygon polygon, Calibration cal, double downsampleFactor) {
        double x = cal == null ? 0.0 : cal.xOrigin;
        double y = cal == null ? 0.0 : cal.yOrigin;
        return ROIConverterIJ.convertToPointsList(polygon, x, y, downsampleFactor);
    }

    private static List<Point2> convertToPointsList(FloatPolygon polygon, double xOrigin, double yOrigin, double downsampleFactor) {
        ArrayList<Point2> points = new ArrayList<Point2>();
        for (int i = 0; i < polygon.npoints; ++i) {
            float x = (float)ROIConverterIJ.convertLocationfromIJ(polygon.xpoints[i], xOrigin, downsampleFactor);
            float y = (float)ROIConverterIJ.convertLocationfromIJ(polygon.ypoints[i], yOrigin, downsampleFactor);
            points.add(new Point2((double)x, (double)y));
        }
        return points;
    }
}

