/*
 * Decompiled with CFR 0.152.
 */
package qupath.imagej.tools;

import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import qupath.lib.analysis.images.SimpleModifiableImage;

public class PixelImageIJ
implements SimpleModifiableImage {
    private ImageProcessor ip;

    public PixelImageIJ(ImageProcessor ip) {
        this.ip = ip;
    }

    public float getValue(int x, int y) {
        return this.ip.getf(x, y);
    }

    public void setValue(int x, int y, float val) {
        this.ip.setf(x, y, val);
    }

    public int getWidth() {
        return this.ip.getWidth();
    }

    public int getHeight() {
        return this.ip.getHeight();
    }

    public float[] getArray(boolean direct) {
        if (this.ip instanceof FloatProcessor) {
            float[] pixels = (float[])this.ip.getPixels();
            if (direct) {
                return pixels;
            }
            return (float[])pixels.clone();
        }
        int n = this.ip.getWidth() * this.ip.getHeight();
        float[] pixels = new float[n];
        for (int i = 0; i < n; ++i) {
            pixels[i] = this.ip.getf(i);
        }
        return pixels;
    }
}

